/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IdentityAssertionTrust;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.IdentityAssertionTrustEvent;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.util.ArrayList;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.IdentityAssertionTrustEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.IdentityAssertionTrustEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Iterator;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class PAssertedAuthenticatorFactory implements IdentityAssertionTrustEventListener {

    private static PAssertedAuthenticatorFactory paf = null;
    private Hashtable<String, PAssertedAuthenticator> assertionMap = new Hashtable();
    private Authenticator defaultAuth = null;
    private boolean registered = false;

    private PAssertedAuthenticatorFactory() {
        initialize();
        registerListener();

    }

    /**
     * Returns instance of PAssertedAuthenticatorFactory
     * @return instance of PAssertedAuthenticatorFactory
     */
    public static PAssertedAuthenticatorFactory getInstance() {
        if (paf == null) {
            init();
        }
        return paf;
    }

    /**
     * initialize PAssertedAuthenticatorFactory.
     */
    public static synchronized void init() {
        if (paf == null) {
            paf = new PAssertedAuthenticatorFactory();
        }
    }

    public Authenticator getAuthenticator() {
        String key = getTrustConfigIdentifier();
        if (key != null) {
            return this.getAuthenticator(key);
        }
        return defaultAuth;
    }

    public Authenticator getAuthenticator(String key) {
        return assertionMap.get(key);
    }

    private void registerListener() {
        AdminEventListenerRegistry.registerEventListener(IdentityAssertionTrustEvent.eventType, this, IdentityAssertionTrustEventListener.class);
    }

    private void initialize() {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Configs configs = ((Domain) ctx.getRootConfigBean()).getConfigs();
            Config[] configArray = configs.getConfig();
            String tcName = null;
            IdentityAssertionTrust trustConfig = null;
            for (int i = 0; i < configArray.length; i++) {
                SecurityService ss = configArray[i].getSecurityService();
                IdentityAssertionTrust[] iatList = ss.getIdentityAssertionTrust();
                for (int j = 0; j < iatList.length; j++) {
                    IdentityAssertionTrust iat = iatList[j];
                    PAssertedAuthenticator pa = new PAssertedAuthenticator(iat);
                    String key = iat.getId();
                    assertionMap.put(key, pa);
                    if (iat.isIsDefault()) {
                        defaultAuth = pa;
                    }
                }
            }

        } catch (ConfigException ex) {
            Logger.getLogger(PAssertedAuthenticator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getTrustConfigIdentifier() {
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        if (im == null) {
            return null;
        }

        ComponentInvocation inv = null;

        inv = im.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        Object container = inv.getContainerContext();
        JndiNameEnvironment env = (JndiNameEnvironment) Switch.getSwitch().getDescriptorFor(container);
        // env can be null if it's CMP SQL generation
        if (env == null) {
            return null;
        }
        if (env instanceof SipBundleDescriptor) {
            SunWebApp sunSipDesc = ((SipBundleDescriptor) env).getSipApplication().getSunSipDescriptor();
            WebProperty[] props = sunSipDesc.getWebProperty();
            if (props != null) {
                for (int i = 0; i < props.length; i++) {
                    WebProperty prop = props[i];
                    if ("trust-id-ref".equals(prop.getValue("name"))) {
                        return (String) prop.getValue("value");
                    }
                }
            }
        }

        return null;
    }

    public void handleUpdate(IdentityAssertionTrustEvent ue) throws AdminEventListenerException {
        try {
            ConfigContext configContext = ue.getConfigContext();


            ConfigUpdate configUpdate = null;
            ArrayList configChangeList = ue.getConfigChangeList();

            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            Object object;
            Object configObject;

            for (int i = 0; i < configChangeList.size(); i++) {
                configObject = configChangeList.get(i);

                if (configObject instanceof ConfigUpdate) {
                    configUpdate = (ConfigUpdate) (ConfigAdd) configObject;
                    xpath = configUpdate.getXPath();
                    object = configContext.exactLookup(xpath);
                    if (object instanceof IdentityAssertionTrust) {
                        IdentityAssertionTrust iat = (IdentityAssertionTrust) object;
                        PAssertedAuthenticator pa = new PAssertedAuthenticator(iat);
                        String key = iat.getId();
                        assertionMap.put(key, pa);
                        if (iat.isIsDefault()) {
                            defaultAuth = pa;
                        }
                    }
                }
            }
        } catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleCreate(IdentityAssertionTrustEvent ce) throws AdminEventListenerException {
        try {
            ConfigContext configContext = ce.getConfigContext();


            ConfigAdd configAdd = null;
            ArrayList configChangeList = ce.getConfigChangeList();

            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            Object object;
            Object configObject;

            for (int i = 0; i < configChangeList.size(); i++) {
                configObject = configChangeList.get(i);

                if (configObject instanceof ConfigAdd) {
                    configAdd = (ConfigAdd) configObject;
                    xpath = configAdd.getXPath();
                    object = configContext.exactLookup(xpath);
                    if (object instanceof IdentityAssertionTrust) {
                        IdentityAssertionTrust iat = (IdentityAssertionTrust) object;
                        PAssertedAuthenticator pa = new PAssertedAuthenticator(iat);
                        String key = iat.getId();
                        assertionMap.put(key, pa);
                        if (iat.isIsDefault()) {
                            defaultAuth = pa;
                        }
                    }
                }
            }
        } catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(IdentityAssertionTrustEvent de) throws AdminEventListenerException {
        try {
            String elementId = de.getElementId();
            if (elementId != null && elementId.length() > 0) {
                Object obj = assertionMap.remove(elementId);
                if (obj == defaultAuth) {
                    defaultAuth = null;
                }
            }

        } catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }
}
