/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import java.security.spec.AlgorithmParameterSpec;

import javax.servlet.sip.SipServletRequest;

import javax.servlet.sip.SipServletResponse;

/**
 * represents SIP servlet request parameter
 * @author k>Venugopal@sun.com
 */
public class SipAlgorithmParamImpl implements AlgorithmParameterSpec {

    private SipServletRequest req = null;
    private SipServletResponse resp = null;
    private String realm = null;
    private boolean isProxy = false;

    public SipAlgorithmParamImpl(SipServletRequest req) {
        this.req = req;
    }

    public SipAlgorithmParamImpl(SipServletRequest req, String realm,boolean proxy) {
        this.req = req;
        this.realm = realm;
        this.isProxy = proxy;
    }

    public SipAlgorithmParamImpl(SipServletRequest req, SipServletResponse resp) {
        this.req = req;
        this.resp = resp;        
    }

    public SipServletRequest getRequest() {
        return req;
    }

    public SipServletResponse getResponse() {
        return resp;
    }

    public String getRealm() {
        return realm;
    }

    public boolean isProxy() {
        return isProxy;
    }    
}
