/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;


/**
 * This class is a place where public constants are defined. Among other things
 * default values for preferences are defined here. Default values can be typed
 * int and boolean for preferences that represent integer and boolean values.
 * </p>
 * The default values encoded here should also be encoded in
 * conf/tm.preferences, even if the parameters defined in there are enclosed in
 * <!-- -->.
 * </p>
 * For SUBSEQUENT_PORT_BASE_DEFAULT the value encoded here should preferrably
 * coincide with the default value documented in the Installation Guide for EAS
 * on TSP.
 *
 * @author erarafo
 * @reviewed ejoelbi 2007-jan-17
 */
public class Constants {
    /**
     * Constants of public scope.
     */
    public static final String CONFIG_CLASS = ConvergedContextConfig.class.getName();
    public static final String CONTEXT_CLASS = ConvergedContextImpl.class.getName();
    public final static String TM_PREFERENCES_NODE = "com/ericsson/eas/tm";
    public final static String TM_TIMER_PREFERENCES_NODE = TM_PREFERENCES_NODE +
        "/timer";
    public final static String EMPTY_STRING = "";
    public final static int UNINITIALIZED_INT = -1;
    public final static boolean DEFAULT_TCP_TRANSPORT = false;
    public final static int JMX_DEFAULT_PORT_DEFAULT = 1099;
    public final static int THREADPOOL_SIZE_DEFAULT = 10;
    public final static boolean APP_DISPATCHER_LOOP_INTERNAL_DEFAULT = true;
    public final static String ENUM_TOPDOMAIN_DEFAULT = "e164.arpa";
    public final static int DNS_CACHE_SIZE_DEFAULT = 20000;
    public final static int TIMER_T1_DEFAULT = 500;
    public final static int TIMER_T2_DEFAULT = 4000;
    public final static int TIMER_T4_DEFAULT = 5000;
    public final static int DEFAULT_PROXY_POOL_SIZE = 2;
    public final static int DEFAULT_PROXY_RETRIES = 2;
    public final static int DEFAULT_PROXY_SOCKET_TIMEOUT = 120000;
    public final static int DEFAULT_PROXY_CONNECTION_TIMEOUT = 0;
    public final static boolean OVERLOAD_REGULATION = false;
    public final static int SAMPLE_RATE = 1;
    public final static int NUMBER_OF_SAMPLES = 2;
    public final static int HTTP_THRESHOLD = 70;
    public final static int IR_THRESHOLD = 70;
    public final static int SR_THRESHOLD = 80;
    public final static int MM_THRESHOLD = 99;
    public final static boolean CPU_OVERLOAD_ENABLED = true;
    public final static int CPU_ALARM_THRESHOLD = 70;
    public final static int SIP_LINK_TIMEOUT = 10;
    public final static int SIP_LINK_TIMEOUT_RETRIES = 25;
    public final static int SIP_LINK_WAIT_LOCK_TIMEOUT = 5000;
    public final static int SIP_LINK_MAX_QUEUE_LENGTH = 50;
    public final static int SIP_LINK_THREAD_LOCK_LEVEL = 40;
    public final static String BIND_TO_ANY = "0.0.0.0";
    public static final String HTTP_SUBSEQUENT_PORT = "HTTP_SUBSEQUENT_PORT";
    public static final String SIP_PUBLIC_HOST = "SIP_PUBLIC_HOST";
    public static final String SIP_PUBLIC_PORT = "SIP_PUBLIC_PORT";
    public final static boolean ERROR_RESPONSE_ENABLED_DEFAULT = false;
    public final static int SIP_LINK_ALIVE_TIMEOUT = 120;
    public final static boolean EAS_503_DISABLED_DEFAULT = false;
    public static final String NOTIFICATION_MBEAN_NAME = "GENERIC:type=EAS,name=Notification Service";
    public static final String SIP_PORT = "SIP_PORT";
    public static final String DEFAULT_SIP_PORT = "5060";
    public static final String DEFAULT_SIPS_PORT = "5061";
    public static final String HOST = "HOST";
    public static final String LAN_ADDRESS = "LanAddress";
    public static final String PROXY_BEROUTE_HEADER = "proxy-beroute";
    public static final String PROXY_BEKEY_HEADER = "proxy-bekey";
    public static final String BEROUTE = "BERoute";
    public static final String BEROUTE_URI_PARAMETER = ";" + BEROUTE + "=";
    public static final String BEKEY = "BEKey";
    public static final String BEKEY_URI_PARAMETER = ";" + BEKEY + "=";
    public static final String SAS_ID_URI_PARAMETER = ";sipappsessionid=";
    public static final String REQUEST_URL_SESSION_NOTE = "com.ericsson.converged.sessionnote.requesturl";
    public static final String BEKEY_SESSION_NOTE = "com.ericsson.converged.sessionnote.bekey";
    public static final String BEROUTE_SESSION_NOTE = "com.ericsson.converged.sessionnote.beroute";
    public static final String SESSION_VERSIONS_SESSION_NOTE = "com.ericsson.converged.sessionnote.versions";
}
