/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.sip.Layer;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.glassfish.comms.startup.stack.StackModel;
import java.util.logging.Level;
import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;


/**
 * Dispatcher handler is a singelton which maintains the list of dispatchers. A
 * dispatcher is a SIP processing element and determines the processing of SIP
 * messages in the container. Dispatchers are configurable and defined in a xml
 * file. DispatcherHAndler distinguishes between the following types of
 * dispatchers. TransportDispatcher Represents the entry point for SIP i.e. and
 * has a listening port for SIP. TransactionDispatcher Represents the entry
 * point to the transaction layer, in the case the container is configured to
 * run in "transaction" mode ApplicationDispatcher Represent the interface pont
 * between the SIP stack and the container. Dispatcher
 */
public final class LayerHandler implements StackModel<Layer> {
    private Logger log = LogUtil.SIP_LOGGER.getLogger();
    private static LayerHandler layerHandlerInstance = new LayerHandler();
    private ArrayList<Layer> m_layers = new ArrayList<Layer>();

    /**
     * @return The singelton of LayerHandler
     */
    public static LayerHandler getInstance() {
        return layerHandlerInstance;
    }

    /**
     * Returns the stored chain of layers as a shallow copy.
     *
     * @return the stored chain of layers as a shallow copy.
     */
    public List<Layer> getLayers() {
        return new ArrayList<Layer>(m_layers);
    }

    /**
     * Stores the layers in a List and link the new Layer to the Last stored
     * layer
     *
     * @param nextLayer
     */
    public void addLayer(Layer nextLayer) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Add layer: "+nextLayer+" to "+m_layers);
        }
        int currentSize = m_layers.size();

        if (currentSize > 0) {
            Layer currentLayer = m_layers.get(currentSize - 1);
            currentLayer.registerNext(nextLayer);
        }

        m_layers.add(nextLayer);
    }

    public void clear() {
        m_layers.clear();
    }
}
