/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation indicates that the method annotated is a property setter
 * to be called by Configuration to initialize or update the property with
 * the value of configuration item for the key and node indicted in the
 * annotation. The property may be of any types that takes a String argument in
 * its constructor or a primitive type and their wrapper types.
 * 
 * This annotation only covers to most common and simple cases of configuration.
 * Use the ConfigFactory and Config ConfigChangeListner when this annotation doesn't
 * suffice.
 * 
 * An object bearing this annotation needs to be activated for configuration to
 * let the annotation take effect. Use the ConfigFactory to do so:
 * <p>
 * <code>ConfigFactory.instance().activateConfiguration(configurable);</code>
 * <p>
 * @param node The node under which the Configuration Item is provided.
 * @param key The key to the Configuration Item. Default is the property name as taken from the setter, using JavaBean conventions.
 * @param value The default value to use when the Configuration does not yield a value and the usage == UsagePolicy.DEFAULT
 * @param usage Indicates how the Configuration Item is to be used for reconfig. 
 * @param usageAtStartup Indicates how the Configuration Item is to be used for startup.
 * @param update The update policy on when the setter is called. Default is for each change.
 * 
 * Note that there is no rollback to (hardcoded) values for FAIL, 
 * WARN and IGNORE instead the last used value as is (setter is not
 * called).
 *
 * @author elnelbo
 */
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value=ElementType.METHOD)
public @interface Configuration {
    /** The node under which the Configuration Item is provided.*/
    String node() default "";

    /** The key to the Configuration Item. Default is the property name as 
     * taken from the setter, using JavaBean conventions.*/
    String key() default "";    

    /** The default value to use when the Configuration does not yield a value 
     * and the usage == UsagePolicy.DEFAULT.*/
    String value() default "";

    /** Indicates how the Configuration Item is to be used at startup.<br> 
     * UsagePolicy.FAIL -> will break when item is not provided in the 
     * Configuration, <br>
     * UsagePolicy.WARN -> this will log a warning,<br> 
     * UsagePolicy.IGNORE -> this will ignore,<br> 
     * UsagePolicy.DEFAULT -> use the value argument as default.*/
    UsagePolicy usageAtStartup() default UsagePolicy.IGNORE;

    /** Indicates how the Configuration Item is to be used when reconfiguring. <br> 
     * UsagePolicy.FAIL -> will break when item is not provided in the 
     * Configuration, <br>
     * UsagePolicy.WARN -> this will log a warning,<br> 
     * UsagePolicy.IGNORE -> this will ignore,<br> 
     * UsagePolicy.DEFAULT -> use the value argument as default.
     *
     * Note that there is no rollback to (hardcoded) values for FAIL, 
     * WARN and IGNORE instead the last used value as is (setter is not
     * called). */
    UsagePolicy usage() default UsagePolicy.WARN;

    /** The update policy on when the setter is called. Default is for each 
     * change.*/
    UpdatePolicy update() default UpdatePolicy.DYNAMIC;
}
