/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.config.event;

import com.ericsson.ssa.config.ConfigRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jvnet.glassfish.comms.util.LogUtil;
import java.util.logging.Logger;


/**
 *
 * @author ELNELBO
 */
public class ConfigEventMulticaster implements ConfigEventRegistry {
    private final Logger log = LogUtil.SIP_LOGGER.getLogger();
    protected Map<ConfigChangeListener, List<String>> registry = new HashMap<ConfigChangeListener, List<String>>();

    /**
     * Creates a new instance of ConfigEventMulticaster
     */
    public ConfigEventMulticaster() {
    }

    public synchronized void registerConfigChangeListener(String nodePattern,
        ConfigChangeListener listener) {
        if (registry.containsKey(listener)) {
            List<String> patterns = registry.get(listener);
            patterns.add(nodePattern);
            registry.put(listener, patterns);
        } else {
            List<String> patterns = new ArrayList<String>(1);
            patterns.add(nodePattern);
            registry.put(listener, patterns);
        }
    }

    public synchronized void deregisterConfigChangeListener(ConfigChangeListener listener) {
        registry.remove(listener);
    }

    public void processEvent(ConfigEvent event) {
        Map<ConfigChangeListener, List<String>> registryClone = null;
        synchronized(registry) {
            registryClone = new HashMap<ConfigChangeListener, List<String>>(registry);
        }
        
        ConfigRuntimeException troubles = null;
        for (Map.Entry<ConfigChangeListener, List<String>> entry : registryClone.entrySet()) {
            for (String pattern : entry.getValue()) {
                if (match(pattern, event)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "processEvent    match :) for " +
                        event.getClass().getName() + " with " + pattern +
                        " and " + event.getNode());
                    }
                    try {
                        if (event instanceof ConfigAddEvent) {
                            entry.getKey().handleConfigEvent((ConfigAddEvent) event);
                        }

                        if (event instanceof ConfigUpdateEvent) {
                            entry.getKey().handleConfigEvent((ConfigUpdateEvent) event);
                        }

                        if (event instanceof ConfigRemoveEvent) {
                            entry.getKey().handleConfigEvent((ConfigRemoveEvent) event);
                        }
                    } catch(Exception e) {
                        //This catch may be to wide!
                        //Each listener gets the opertunaty to handle the event.
                        //It lokalizes the effect of troublesome listeners.
                        if (troubles==null) {
                            troubles = new ConfigRuntimeException("Muticasting event ["+
                                    event.getNode()+"] failed for atleast one listener");
                        }
                        troubles.addCause(e);
                    }
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "processEvent no match :( for " +
                        event.getClass().getName() + " with " + pattern +
                        " and " + event.getNode());
                    }
                }
            }
        }
        if (troubles!=null) {
            throw troubles;
        }
    }

    protected boolean match(String nodePattern, ConfigEvent event) {
        return event.getNode().matches(nodePattern);
    }
}
