/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.container;


/**
 * This class holds all configuration parameters for the HttpProxy.
 *
 * @author epiesan
 * @since May 11, 2006
 */
public class HttpProxySettings {
    private int poolSize;
    private int retries;
    private int socketTimeout;
    private int connectionTimeout;

    /**
     * Returns the size of the connection pool for each host.
     *
     * @return Returns the size of the connection pool that
     *   are created by the proxy.
     */
    public int getPoolSize() {
        return poolSize;
    }

    /**
     * Set the size of the connection pool for each host.
     *
     * @param poolSize The size of the connection pool that
     *   are created by the proxy.
     */
    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    /**
     * Returns the timeout value in milliseconds used
     * when the proxy tries to obtain a connection from
     * a connection pool.
     *
     * @return The timeout value.
     */
    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    /**
     * Sets the timeout value in milliseconds used
     * when the proxy tries to obtain a connection from
     * a connection pool.
     *
     * @param connectionTimeout The timeout value in milliseconds.
     */
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /**
     * Returns the maximum number of retries that the proxy
     * will do for each request.
     *
     * @return The maximum number of retries.
     */
    public int getRetries() {
        return retries;
    }

    /**
     * Sets the maximum number of retries that the proxy
     * will do for each request.
     *
     * @param retries The maximum number of retries.
     */
    public void setRetries(int retries) {
        this.retries = retries;
    }

    /**
     * Returns the socket read timeout value in milliseconds.
     * This value is used as the maximum time the proxy
     * will wait for a response before considering the
     * proxy attempt to have failed.
     *
     * @return The socket read timeout value in milliseconds.
     */
    public int getSocketTimeout() {
        return socketTimeout;
    }

    /**
     * Sets the socket read timeout value in milliseconds.
     * This value is used as the maximum time the proxy
     * will wait for a response before considering the
     * proxy attempt to have failed.
     *
     * @param socketTimeout The timeout value in milliseconds.
     */
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}
