/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.UriWrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import org.jvnet.glassfish.comms.deployment.backend.SessionCase;


/**
 * Operand. The Operand abstract provide common services for the operand: equal,
 * contains, exists subdomain-of
 */
public abstract class Operand implements Condition {
    private Collection methodValuesList = SupportedMethod.getEnumNameList();
    private Collection<SessionCase> sessionCaseValueList = new ArrayList<SessionCase>();

    /**
     *
     *
     *
     */
    public Operand() {
        sessionCaseValueList.add(SessionCase.ORIGINATING);
        sessionCaseValueList.add(SessionCase.TERMINATING);
        sessionCaseValueList.add(SessionCase.TERMINATING_UNREGISTERED);
    }

    /**
     * @param name
     *           Name of the attribute to verify
     * @param req
     *           Message to compare
     * @return The sip message value associated to the attribute name
     */
    protected String getAttributeValue(String name, SipServletRequest req) {
        // Special Cases
        if (name.equals("request.session-case")) {
            try {
                SessionCase sessionCase = ((SipServletRequestImpl) req).getSessionCase();

                return sessionCase.toString();
            } catch (Exception ex) {
                return SessionCase.EXTERNAL.toString();
            }
        }

        if (name.equals("request.user.role")) {
            String descriptorRole = getValue();

            if (req.isUserInRole(descriptorRole)) {
                return descriptorRole;
            }
        }

        if (name.equals("request.method")) {
            return req.getMethod();
        }

        // request.uri
        // request.uri.scheme
        // request.uri.user
        // request.uri.host
        // request.uri.port
        if (name.equals("request.uri")) {
            return req.getRequestURI().toString();
        }

        if (name.equals("request.uri.scheme")) {
            return req.getRequestURI().getScheme();
        }

        if (req.getRequestURI().isSipURI()) {
            // these parameters is only valid for SipURI's
            SipURI uri = (SipURI) req.getRequestURI();

            if (name.equals("request.uri.user")) {
                return uri.getUser();
            }

            if (name.equals("request.uri.host")) {
                return uri.getHost();
            }

            if (name.equals("request.uri.port")) {
                return getUriPort(uri);
            }

            if (name.equals("request.uri.tel") &&
                    "phone".equals(uri.getParameter("user"))) {
                return getPhoneNumber(uri.getUser());
            }
        } else if (req.getRequestURI().getScheme()
                          .equalsIgnoreCase(SipFactoryImpl.TEL_URI_PROTOCOL)) {
            if (name.equals("request.uri.tel")) {
                return getPhoneNumber(((TelURL) req.getRequestURI()).getPhoneNumber());
            }
        }

        StringTokenizer token = new StringTokenizer(name, ".");
        int ntok = token.countTokens();
        String[] elements = new String[ntok];

        for (int i = 0; i < ntok; i++) {
            elements[i] = token.nextToken();
        }

        // Request URI parameters
        if (name.startsWith("request.uri.param")) {
            if (elements.length > 3) {
                return new UriWrapper(req).getParameter(elements[3]);
            }
        }

        // General Headers
        //
        // request.<header>.uri
        // request.<header>.uri.scheme
        // request.<header>.uri.user
        // request.<header>.uri.host
        // request.<header>.uri.port
        // request.<header>.uri.display-name
        if (name.startsWith("request.")) {
            if ((elements.length > 2) && "uri".equals(elements[2])) {
                try {
                    if (elements.length < 4) {
                        return req.getHeader(elements[1]);
                    }

                    // Handle request.<header>.uri.scheme
                    if ("scheme".equals(elements[3])) {
                        return req.getAddressHeader(elements[1]).getURI()
                                  .getScheme();
                    }

                    // request.<header>.uri.display-name
                    if ("display-name".equals(elements[3])) {
                        return req.getAddressHeader(elements[1]).getDisplayName();
                    }

                    if (req.getAddressHeader(elements[1]).getURI().isSipURI()) {
                        SipURI headerURI = (SipURI) req.getAddressHeader(elements[1])
                                                       .getURI();

                        if ("user".equals(elements[3])) {
                            return headerURI.getUser();
                        }

                        if ("host".equals(elements[3])) {
                            return headerURI.getHost();
                        }

                        if ("port".equals(elements[3])) {
                            return getUriPort(headerURI);
                        }
                    }
                } catch (ServletParseException e) {
                }
            } else {
                return req.getHeader(elements[1]);
            }
        }

        return "";
    }

    private String getPhoneNumber(String user) {
        // Remove all separators from phone number.
        StringBuffer sb = new StringBuffer();

        if (user != null) {
            char[] chars = user.toCharArray();

            for (int i = 0; i < chars.length; i++) {
                if (Character.isDigit(chars[i])) {
                    sb.append(chars[i]);
                }
            }

            return sb.toString();
        } else {
            return null;
        }
    }

    /**
     * Extract the port from the URI in accordance with the mapping rules of the
     * SSA specification.
     *
     * @param uri
     *           The SipURI
     * @return The port of the URI or the default port for the scheme according
     *         to the SSA specification mapping rules.
     */
    private String getUriPort(SipURI uri) {
        if (uri.getPort() > 0) {
            return Integer.toString(uri.getPort());
        }

        String scheme = uri.getScheme();

        if (scheme.equals(SipFactoryImpl.SIP_URI_PROTOCOL)) {
            return Integer.toString(SipFactoryImpl.SIP_RFC_PORT);
        }

        if (scheme.equals(SipFactoryImpl.SIPS_URI_PROTOCOL)) {
            return Integer.toString(SipFactoryImpl.SIPS_RFC_PORT);
        }

        return null;
    }

    /**
     * @param var
     * @return
     */
    private boolean isMethod(String var) {
        return var.equals("request.method");
    }

    /**
     * @param var
     * @return
     */
    private boolean isSessionCase(String var) {
        return var.equals("request.session-case");
    }

    /**
     * @param var
     * @return
     */
    protected boolean isMethodOrSessionCase(String var) {
        return (isMethod(var) || isSessionCase(var));
    }

    /**
     * @param var
     * @param value
     * @return
     */
    protected boolean isVarValueSupported(String var, String value) {
        if (isMethod(var)) {
            return methodValuesList.contains(value);
        } else if (isSessionCase(var)) {
            return sessionCaseValueList.contains(value);
        } else {
            return true;
        }
    }

    public abstract String getValue();

    public abstract String getVariable();
}
