/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;


public class ResourceReference implements Serializable {
    private static final long serialVersionUID = 3257852060706747188L;

    /**
     * Default value of the res-sharing-scope element is Shareable
     */
    private String sharingScope = SharingScope.SHAREABLE.getName();
    private String name;
    private String type;
    private String authentication;
    private String description;

    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return
     */
    public String getAuthentication() {
        return authentication;
    }

    /**
     * @param authentication
     */
    public void setAuthentication(String authentication) {
        if (!AuthenticationType.contains(authentication)) {
            throw new RuntimeException("The value of the authentication type " +
                "(res-auth element) must be of " +
                AuthenticationType.printNames());
        }

        this.authentication = authentication;
    }

    /**
     * @return
     */
    public String getSharingScope() {
        return sharingScope;
    }

    /**
     * @param sharingScope
     */
    public void setSharingScope(String sharingScope) {
        if (!SharingScope.contains(sharingScope)) {
            throw new RuntimeException("The value of the sharing scope must " +
                "be of " + SharingScope.printNames());
        }

        this.sharingScope = sharingScope;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @param o
     * @return
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if ((o == null) || !(o instanceof ResourceReference)) {
            return false;
        }

        final ResourceReference reference = (ResourceReference) o;

        return (name != null) ? name.equals(reference.name)
                              : (reference.name == null);
    }

    /**
     * @return
     */
    public int hashCode() {
        return ((name != null) ? name.hashCode() : 0);
    }
}
