/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.fm;


/**
 * This is a interface used as a helper for notification and alarm handling in
 * TM
 *
 * @author edtugdi
 * @since 2005-maj-21
 * @reviewed ejoelbi 2006-nov-22
 */
public interface FmTypes {
    public final static String OBJECT_TYPE_EAS = "EAS";
    public final static String INSTANCE_SIP_CONTAINER = "TrafficModule";

    // Notifications
    public final static int EAS_APPLICATION_DEPLOYMENT_STARTED = 3;
    public final static int EAS_APPLICATION_DEPLOYMENT_FINISHED_SUCCESSFULLY = 4;
    public final static int EAS_APPLICATION_DEPLOYMENT_FAILED = 5;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_STARTED = 6;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_FINISHED_SUCCESSFULLY = 7;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_FAILED = 8;
    public final static int EAS_SERVLET_INITIALIZATION_FAILED = 9;

    // Alarms
    public final static int ALARM_DNS_UNREACHABLE = 1;
    public final static String DESC_DNS_UNREACHABLE = "DNS Unreachable";
    public final static int ALARM_CPU_LOAD_LIMIT_EXCEEDED = 2;
    public final static String DESC_ALARM_CPU_LOAD_LIMIT_EXCEEDED = "CPU load limit exceeded";
    public final static int ALARM_TYPE_COMMUNICATIONS = 0;
    public final static int ALARM_TYPE_QUALITY_OF_SERVICE = 1;
    public final static int ALARM_TYPE_PROCESSING_ERROR = 2;
    public final static int ALARM_TYPE_EQUIPMENT = 3;
    public final static int ALARM_TYPE_ENVIRONMENTAL = 4;
    public final static int ALARM_SEVERITY_INDETERMINATE = 0;
    public final static int ALARM_SEVERITY_CRITICAL = 1;
    public final static int ALARM_SEVERITY_MAJOR = 2;
    public final static int ALARM_SEVERITY_MINOR = 3;
    public final static int ALARM_SEVERITY_WARNING = 4;
    public final static int ALARM_SEVERITY_CLEARED = 5;
    public final static String ALARM_PROBABLE_CAUSE = "EAS, DNS Unreachable";
    public final static String CPU_ALARM_PROBABLE_CAUSE = "EAS, CPU Load Limit Exceeded";
}
