/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.UAMode;


public class B2buaHelperPendingMessages {
    private static final Comparator<SipServletMessageImpl> CSEQ_INCREASE_ORDER = new Comparator<SipServletMessageImpl>() {
            public int compare(SipServletMessageImpl m1,
                SipServletMessageImpl m2) {
                return m1.getCSeqNumber() - m2.getCSeqNumber();
            }
        };

    private List<SipServletMessageImpl> uacMessage = null;
    private List<SipServletMessageImpl> uasMessage = null;

    public List<SipServletMessage> get(UAMode mode) {
        List<SipServletMessageImpl> list = null;

        switch (mode) {
        case UAC:
            list = getUACList();

            return get(list);

        case UAS:
            list = getUASList();

            return get(list);
        }

        throw new IllegalArgumentException("UAMode not supported: " + mode);
    }

    private synchronized List<SipServletMessageImpl> getUACList() {
        if (uacMessage == null) {
            uacMessage = new ArrayList<SipServletMessageImpl>();
        }

        return uacMessage;
    }

    private synchronized List<SipServletMessageImpl> getUASList() {
        if (uasMessage == null) {
            uasMessage = new ArrayList<SipServletMessageImpl>();
        }

        return uasMessage;
    }

    private List<SipServletMessage> get(List<SipServletMessageImpl> list) {
        synchronized (list) {
            // remove the message that is committed
            for (Iterator<SipServletMessageImpl> it = list.iterator();
                    it.hasNext();) {
                if (it.next().isCommitted()) {
                    it.remove();
                }
            }

            // sort the messages in CSeq increasing order
            Collections.sort(list, CSEQ_INCREASE_ORDER);

            return new ArrayList<SipServletMessage>(list);
        }
    }

    public void add(SipServletMessageImpl m, UAMode mode) {
        switch (mode) {
        case UAC:
            add(m, uacMessage);

            break;

        case UAS:
            add(m, uasMessage);

            break;

        default:
            throw new IllegalArgumentException("UAMode not supported: " + mode);
        }
    }

    private void add(SipServletMessageImpl m, List<SipServletMessageImpl> list) {
        synchronized (list) {
            list.add(m);
        }
    }

    public void remove(SipServletMessageImpl m, UAMode mode) {
        switch (mode) {
        case UAC:
            remove(m, uacMessage);

            break;

        case UAS:
            remove(m, uasMessage);

            break;

        default:
            throw new IllegalArgumentException("UAMode not supported: " + mode);
        }
    }

    private void remove(SipServletMessageImpl m,
        List<SipServletMessageImpl> list) {
        synchronized (list) {
            list.remove(m);
        }
    }
}
