/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * Part of the Proxy implementation. There might be several SequentialTargetSet
 * per Proxy.
 *
 * @author ehsroha
 */
public class SequentialTargetSet extends TargetSet {
    private static final Logger _log = LogUtil.SIP_LOGGER.getLogger();
    private List<TargetSet> _targetSets = null;
    private Iterator<TargetSet> _iter = null;
    private boolean _isStarted = false;
    private final boolean _isRecurse;

    /**
     * The constructor of the SequentialTargetSet implementation.
     *
     */
    public SequentialTargetSet(CreatedTargetSet t, boolean isRecurse) {
        super(t.getProxyImpl());
        _isRecurse = isRecurse;
        _targetSets = new ArrayList<TargetSet>(t.getTargetSets());

        for (TargetSet child : getTargetSets()) {
            child.setParent(this);
        }
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return _targetSets;
    }

    public boolean hasNext() {
        return _iter.hasNext();
    }

    public void next() {
        TargetSet t = _iter.next();

        try {
            t.proxyTo();
        } catch (IllegalStateException e) {
            if (_log.isLoggable(Level.WARNING)) {
                // FIXME more detailed error descr
                _log.log(Level.WARNING, "Failed to proxy request. ", e);
            }

            // remove from target set that does not work...
            getTargetSets().remove(t);
        }
    }

    public void proxyTo() throws IllegalStateException {
        if (isStarted()) {
            throw new IllegalStateException("Already started");
        }

        _isStarted = true;
        _iter = getTargetSets().iterator();

        if (hasNext()) {
            next();
        }
    }

    public void cancel() throws IllegalStateException {
        if (isStarted()) {
            for (TargetSet t : getTargetSets()) {
                t.cancel();
            }
        }
    }

    /**
     * Always return false
     *
     * @return always false
     */
    public boolean getParallel() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return _isStarted;
    }

    @Override
    public boolean getRecurse() {
        return _isRecurse;
    }
}
