/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;


/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public final class SingleLineHeader extends Header implements Externalizable {
    /**
     *
     */
    private static final long serialVersionUID = 3256437027846566967L;
    private AddressOrValue addressOrValue;

    /**
     * @param pretty
     * @param systemHeader
     */
    public SingleLineHeader(String pretty, boolean systemHeader) {
        super(pretty, systemHeader, true);
    }

    public SingleLineHeader() {
    } // Only for the Externalizable interface!

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF((addressOrValue != null) ? addressOrValue.toString() : "");
        super.writeExternal(output);
    }

    public void readExternal(ObjectInput input) throws IOException {
        addressOrValue = new AddressOrValue(input.readUTF());
        super.readExternal(input);
    }

    protected Object clone() {
        SingleLineHeader newHeader = new SingleLineHeader(new String(_name),
                _readOnly);

        if (addressOrValue != null) {
            newHeader.addressOrValue = (AddressOrValue) addressOrValue.clone();
        }

        return newHeader;
    }

    public String getValue() {
        if (addressOrValue != null) {
            return addressOrValue.toString();
        }

        return null;
    }

    public void setValue(String value, boolean ignore) {
        if (value != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(value);
            } else {
                addressOrValue.setValue(value);
            }
        }
    }

    public Address getAddressValue() throws ServletParseException {
        if (addressOrValue != null) {
            Address address = addressOrValue.getAddressValue();

            // Even the address of a system header should be protected.
            ((AddressImpl) address).setReadOnly(_readOnly);

            return address;
        }

        return null;
    }

    public void setAddressValue(Address address, boolean first) {
        if (address != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(address);
            } else {
                addressOrValue.setAddressValue(address);
            }
        }
    }

    public Parameterable getParameterableValue() throws ServletParseException {
        if (addressOrValue != null) {
            Parameterable parameterable = addressOrValue.getParameterableValue();

            // Even the Parameterable of a system header should be protected.
            ((ParameterableImpl) parameterable).setReadOnly(_readOnly);

            return parameterable;
        }

        return null;
    }

    public void setParameterableValue(Parameterable parameterable, boolean first) {
        if (parameterable != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(parameterable);
            } else {
                addressOrValue.setParameterableValue(parameterable);
            }
        }
    }

    public ListIterator<String> getValues() {
        return new HeaderIterator<String>((addressOrValue != null)
            ? addressOrValue.toString() : null);
    }

    public ListIterator<Address> getAddressValues()
        throws ServletParseException {
        Address address = getAddressValue();

        return new HeaderIterator<Address>(address);
    }

    public ListIterator<Parameterable> getParameterableValues()
        throws ServletParseException {
        Parameterable parameterable = getParameterableValue();

        return new HeaderIterator<Parameterable>(parameterable);
    }

    public void removeValues() {
        addressOrValue = null;
    }

    public void merge(Header h) {
        throw new UnsupportedOperationException("Header = " + _name +
            " old val = " + String.valueOf(addressOrValue) + " merge with = " +
            h.getName() + " : " + h.getValue());
    }

    public String toString() {
        if (addressOrValue != null) {
            StringBuilder sb = new StringBuilder(_name);
            sb.append(": ");
            sb.append(addressOrValue.toString());
            sb.append(SipFactoryImpl.NEW_LINE);

            return sb.toString();
        }

        return "";
    }

    class HeaderIterator<T> implements ListIterator<T> {
        private ListIterator<T> _li;

        public HeaderIterator(T val) {
            List<T> l = new ArrayList<T>();

            if (val != null) {
                l.add(val);
            }

            _li = l.listIterator();
        }

        public void add(T o) {
            if (_readOnly) {
                throw new IllegalArgumentException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }

        public boolean hasNext() {
            return _li.hasNext();
        }

        public boolean hasPrevious() {
            return _li.hasPrevious();
        }

        public T next() {
            return _li.next();
        }

        public int nextIndex() {
            return _li.nextIndex();
        }

        public T previous() {
            return _li.previous();
        }

        public int previousIndex() {
            return _li.previousIndex();
        }

        public void remove() {
            if (_readOnly) {
                throw new IllegalArgumentException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }

        public void set(T o) {
            if (_readOnly) {
                throw new IllegalArgumentException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }
    }
}
