/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.PathNode.Type;

import java.util.List;

import javax.servlet.sip.Address;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;


/**
 * The SipSession represents the SSA point-to-point SIP relationship which is
 * almost equal to a SIP dialog (it extends the dialog definition, see
 * specification). Important that this implementation will use getters and
 * setters internally since it should be possible to serialize the content to
 * external media.
 *
 * @author ehsroha
 */
public interface SipSessionBase extends SipSessionInterface {
    public boolean isDerived();

    public SipApplicationSessionImpl getApplicationSessionImpl();

    public String getHandler();

    /**
     * @return the to tag for this session.
     */
    public String getToTag();

    /**
     * @return true if no to tag has been set in this dialog otherwise false.
     */
    public boolean hasNoToTag();

    /**
     * @return the from tag of this session.
     */
    public String getFromTag();

    public void setType(Type type);

    public Address getTo();

    /**
     * Tries to register the DialogFragment with the toTag of the message. If
     * successful a original or derived session is returned. If unsuccessful a
     * confirmed DialogFragment with the toTag of the message is searched for. If
     * found the message is updated with this DialogFragment and a original or
     * derived session is returned. If no DialogFragment is found the original
     * DialogFragment is cloned and it is recursively sent to this method.
     *
     * @param req
     *        the message with the toTag to be set in the DialogFragment
     * @param d
     *        the DialogFragment to register the session in.
     * @return an original or derived session
     */
    public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(
        SipServletRequestImpl req, DialogFragment d);

    /**
     * Tries to register the DialogFragment with the toTag of the message. If
     * successful a original or derived session is returned. If unsuccessful a
     * confirmed DialogFragment with the toTag of the message is searched for. If
     * found the message is updated with this DialogFragment and a original or
     * derived session is returned. If no DialogFragment is found the original
     * DialogFragment is cloned and it is recursively sent to this method.
     *
     * @param resp
     *        the message with the toTag to be set in the DialogFragment
     * @param d
     *        the DialogFragment to register the session in.
     * @return an original or derived session
     */
    public SipSessionBase getOriginalOrDerivedSessionAndRegisterDialog(
        SipServletResponseImpl resp, DialogFragment d);

    /**
     * This is a specialized version of SipSession.invalidate() that is used to
     * determine the call to invalidate was due to that a ApplicationSession
     * expired or was called from SipServlet code.
     *
     * @param hasTimedOut
     *        true if an ApplicationSession has expired
     */
    public void invalidate(boolean hasTimedOut);

    /**
     * To determine if the session is still valid or if it was previsously
     * invalidate
     *
     * @return true if session is still valid
     */
    public boolean isValid();

    /**
     * This is an optimization made by the container to let applications access
     * the remote target via the attribute map of the sip session with the key:
     * "com.ericsson.ssa.RemoteTarget". e.g. URI contact = (URI)
     * resp.getSession().getAttribute("com.ericsson.ssa.RemoteTarget");
     *
     * @param contact
     */
    public void setRemoteTarget(URI contact);

    public URI getRemoteTarget();

    /**
     * PRACK SIP message
     * CR38 allow only one 1xx reliable at a time
     * and a 200OK (INVITE) is not take in account if 1xx reliable contain an SDP.
     */
    public boolean set1xxReliableOngoing(boolean sdp);

    public boolean is1xxReliableOngoing();

    public boolean is1xxReliableSDP();

    public void reset1xxReliable();

    /**
     * UPDATE SIP message
     * CR38 allow only one UPDATE at a time
     */
    public boolean setUpdateOngoing();

    public void resetUpdateOngoing();

    //JSR289
    // Used by ApplicationDispatcher to set this before invoking of servlets
    public void setRegion(String region);

    // Used by ApplicationDispatcher to set this before invoking of servlets
    public void setSubscriberURI(URI subscriberURI);

    public String getLinkedSipSessionId();

    public void setLinkedSipSessionId(String id);

    public String getFragmentId();

    /**
     * Returns true if this SipSession is replicable, false otherwise.
     *
     * @return true if this SipSession is replicable, false otherwise
     */
    public boolean isReplicable();

    /**
     * Returns list of uncommitted messages. Part of B2buaHelper
     * @param mode
     * @return List of uncommitted messages
     */
    public List<SipServletMessage> getPendingMessages(UAMode mode);

    /**
     * If invoked this sip session is made eligible for saving.
     * This is normally invoked after the sip session becomes confirmed.
     */
    public void setShouldBePersisted();
    
    public void updateSipSessionState(SipServletResponse resp, PathNode.Type type);
    public void updateSipSessionState(SipServletRequest req, PathNode.Type type);

    /**
     * Utility method for updating access times  
     */
    public void access();

    /**
     * Gets the CSEQ.
     * @return the CSEQ
     */
    public int getCSeq();
}
