/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.ConvergedContext;
import org.jvnet.glassfish.comms.deployment.backend.SipApplicationListeners;
import com.ericsson.ssa.sip.PathNode.Type;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;

import java.io.Serializable;

import javax.servlet.sip.Address;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;


/**
 * Interface to a session manager responsible for managing the SipSession
 * and SipApplicationSession instances of a converged context.
 *
 * @author jluehe
 */
public interface SipSessionManager {
    /**
     * Associates the given ConvergedContext with this SipSessionManager.
     *
     * @param context The ConvergedContext with which to associate this
     * SipSessionManager
     */
    public void setContext(ConvergedContext context);

    /**
     * Gets the ConvergedContext with which this SipSessionManager has been
     * associated.
     *
     * @return The ConvergedContext with which this SipSessionManager has
     * been associated.
     */
    public ConvergedContext getContext();

    /**
     * Adds the given SipSession to this SipSessionManager's active cache.
     *
     * @param sipSession The SipSession to add
     *
     * @return the previous SipSession, or null
     */
    public SipSession addSipSession(SipSessionDialogImpl sipSession);

    /**
     * Adds the given SipApplicationSession to this SipSessionManager's
     * active cache.
     *
     * @param sas The SipApplicationSession to add
     *
     * @return the previous SipApplicationSession, or null
     */
    public SipApplicationSession addSipApplicationSession(SipApplicationSessionImpl sas);

    /**
     * Adds the given ServletTimer to this SipSessionManager's
     * active cache.
     *
     * @param sas The ServletTimer to add
     *
     * @return the previous ServletTimer, or null
     */
    public ServletTimer addServletTimer(ServletTimerImpl timer);

    /**
     * Creates a new SipApplicationSession.
     *
     * @param sipApplicationListeners The SipApplicationListeners whose
     * SipApplicationSessionListeners need to be notified of the session
     * creation
     *
     * @return The new SipApplicationSession
     */
    public SipApplicationSessionImpl createSipApplicationSession(
        SipApplicationListeners sipApplicationListeners);

    /**
     * Creates a new SipApplicationSession with the given id.
     *
     * @param id The id to assign to the new SipApplicationSession
     * @param sipApplicationListeners The SipApplicationListeners whose
     * SipApplicationSessionListeners need to be notified of the session
     * creation
     *
     * @return The new SipApplicationSession
     */
    public SipApplicationSessionImpl createSipApplicationSession(String id,
        SipApplicationListeners sipApplicationListeners);
    
    /**
     * Gets the SipApplicationSession with the given id.
     *
     * @return The SipApplicationSession with the given id, or null if not
     * found
     * @throws RemoteLockException
     */
    public SipApplicationSessionImpl findSipApplicationSession(String id)
        throws RemoteLockException;

    /**
     * Gets the SipApplicationSession with the given id.
     *
     * @return The SipApplicationSession with the given id, or null if not
     * found
     * @throws RemoteLockException
     */
    public SipApplicationSessionImpl findSipApplicationSession(String id,
                                                               boolean force)
        throws RemoteLockException;

    /**
     * Removes the given SipApplicationSession from this SipSessionManager.
     *
     * @param appSession The SipApplicationSession to be removed
     */
    public void removeSipApplicationSession(SipApplicationSessionImpl appSession);

    /**
     * Creates a new SipSession and adds it to the given SipApplicationSession.
     *
     * @param set
     * @param to
     * @param appSession
     * @param handler
     *
     * @return The new SipSession
     */
    public SipSessionDialogImpl createSipSession(DialogSet set, Address to,
        SipApplicationSessionImpl appSession, String handler);

    /**
     * Creates a new SipSession and adds it to the given SipApplicationSession.
     *
     * @param set
     * @param to
     * @param appSession
     * @param handler
     * @type type
     *
     * @return The new SipSession
     */
    public SipSessionDialogImpl createSipSession(DialogSet set, Address to,
        SipApplicationSessionImpl appSession, String handler, Type type);

    /**
     * Gets the SipSession with the given id.
     *
     * @return The SipSession with the given id, or null if not found
     */
    public SipSessionDialogImpl findSipSession(String id)
        throws RemoteLockException ;

    public SipSessionDialogImpl findSipSession(String id,
                                               boolean loadDependencies)
        throws RemoteLockException ;

    /**
     * Removes the given SipSession from this SipSessionManager.
     *
     * The SipSession is also removed from its SipApplicationSession parent,
     * if it had been attached to any.
     *
     * @param sipSession The SipSession to remove
     */
    public void removeSipSession(SipSessionDialogImpl sipSession);

    /**
     * Creates a new ServletTimer.
     *
     * @return The new ServletTimer
     */
    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas,
        Serializable info, long delay, TimerListener listener);

    /**
     * Creates a new ServletTimer.
     *
     * @return The new ServletTimer
     */
    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas,
        Serializable info, long delay, boolean fixedDelay, long period,
        TimerListener listener);

    /**
     * Gets the ServletTimer with the given id.
     *
     * @return The ServletTimer with the given id, or null if not found
     */
    public ServletTimerImpl findServletTimer(String id)
        throws RemoteLockException;

    public ServletTimerImpl findServletTimer(String id,
                                             boolean loadDependencies)
        throws RemoteLockException;

    /**
     * Removes the given ServletTimer.
     *
     * @param timer The ServletTimer to be removed
     */
    public void removeServletTimer(ServletTimerImpl timer);

    /**
     * Gets the persistence type of this SipSessionManager.
     */
    public String getPersistenceType();

    /**
     * @return True if this SipSessionManager should participate in a repair
     * during failure, and false otherwise
     */
    public boolean isRepairDuringFailure();

    /**
     * @return The application id of this SipSessionManager
     */
    public String getApplicationId();

    /**
     * Releases any resources held by this SipSessionManager.
     */
    public void release();

    /**
     * Logs the active cashes of the manager.
     */
    public void logActiveObjects();
}
