/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip.dns;

import org.xbill.DNS.SRVRecord;

import java.util.Comparator;


public class SrvComparator implements Comparator {
    private static final int compBEFORE = -1;
    private static final int compEQUAL = 0;
    private static final int compAFTER = 1;

    public SrvComparator() {
    }

    public int compare(Object o1, Object o2) {
        SRVRecord rec1 = (SRVRecord) o1;
        SRVRecord rec2 = (SRVRecord) o2;
        int comparison = comparePriority(rec1, rec2);

        if (comparison != compEQUAL) {
            return comparison;
        }

        comparison = compareWeight(rec1, rec2);

        if (comparison != compEQUAL) {
            return comparison;
        }

        // for records which has the same priority&weight
        // compare hashcode so the sortorder is allways the same
        // otherwise the random distributions of srv records is fucked up
        // due to that the caching is decided to be performed in dnsjava
        return compareHashCode(rec1, rec2);
    }

    public int comparePriority(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.getPriority() < rec2.getPriority()) ? compBEFORE
                                                          : ((rec1.getPriority() == rec2.getPriority())
        ? compEQUAL : compAFTER));
    }

    public int compareWeight(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.getWeight() < rec2.getWeight()) ? compBEFORE
                                                      : ((rec1.getWeight() == rec2.getWeight())
        ? compEQUAL : compAFTER));
    }

    public int compareHashCode(SRVRecord rec1, SRVRecord rec2) {
        return ((rec1.hashCode() < rec2.hashCode()) ? compBEFORE
                                                    : ((rec1.hashCode() == rec2.hashCode())
        ? compEQUAL : compAFTER));
    }

    public boolean equals(Object obj) {
        return equals(obj);
    }
}
