/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip.dns;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * @reviewed ejoelbi 2006-oct-23
 */
public class TargetFailedRegister extends TimerTask {
    private ConcurrentHashMap<String, Long> myHashMap = new ConcurrentHashMap<String, Long>();

    // private final int myKeepValue=15; // in secs
    private final int myTimerInterval = 60; // in

    // secs
    private Timer myTimer;
    private Logger logger = LogUtil.SIP_LOGGER.getLogger();

    /**
     * This object is used to control access to myTimer.<br>
     * myTimer variable is accessed from more then one Thread (SIP worker Thread
     * and Timer internal Thread).<br>
     * So the access to the variable should be synchronized.
     */
    private final Object lock = new Object();

    public TargetFailedRegister() {
    }

    public void registerFailed(TargetTuple target, int expireValue) {
        // String failedEntryKey = protocolName+":"+ip+":"+port;
        String failedEntryKey = target.key();

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registerFailed :" + failedEntryKey);
        }

        // save current timestamp
        // previous entry gets replaced if any
        myHashMap.put(failedEntryKey,
            new Long(new java.util.Date().getTime() + (expireValue * 1000)));

        // The only purpose of the timer is not to keep
        // old entrys in the hashmap (i.e tuples not beeing retried)
        synchronized (lock) {
            if (myTimer == null) {
                myTimer = new Timer();
                myTimer.scheduleAtFixedRate(this, 0, myTimerInterval * 1000);
            }
        }
    }

    // public boolean isFailed(String protocolName, String ip, int port)
    public boolean isFailed(TargetTuple target) {
        // String failedEntryKey = protocolName+":"+ip+":"+port;
        String failedEntryKey = target.key();

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check if target failed:" + failedEntryKey);
        }

        boolean targetIsFailed = false;
        Object o = myHashMap.get(failedEntryKey);

        if (o != null) {
            long expireAt = ((Long) o).longValue();
            long now = new java.util.Date().getTime();

            if (expireAt > now) {
                targetIsFailed = true;
            } else {
                myHashMap.remove(o);
            }
        }

        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "check if target failed:" + targetIsFailed);
        }

        return targetIsFailed;
    }

    public void debugRegister() {
        logger.log(Level.FINE, "____________________________");
        logger.log(Level.FINE, "Debug status in failed targets register\n");

        java.util.Enumeration<Long> e = myHashMap.elements();
        java.util.Enumeration<String> f = myHashMap.keys();

        while (e.hasMoreElements() && f.hasMoreElements()) {
            logger.log(Level.FINE,
                f.nextElement() + " timestamp:" + e.nextElement());
        }

        logger.log(Level.FINE, "____________________________");
    }

    public void clean() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Cleaning the TargetFailedRegister");
        }

        java.util.Enumeration<Long> e = myHashMap.elements();
        java.util.Enumeration<String> f = myHashMap.keys();

        while (e.hasMoreElements()) {
            Long entry = e.nextElement();
            long now = new java.util.Date().getTime();

            if (entry.longValue() <= now) {
                String key = f.nextElement();

                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE,
                        "removing " + key + " timestamp:" + entry.longValue());
                }

                myHashMap.remove(key);
            }
        }

        // if no failed entries left we may cancel the timer
        // is started again if new entries is added
        if (myHashMap.size() == 0) {
            synchronized (lock) {
                myTimer.cancel();
                myTimer = null;

                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE,
                        "Cancel the TargetFailedRegister timer");
                }
            }
        }
    }

    public void run() {
        clean();
    }
}
