/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.SipMonitoring;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.timer.GeneralTimerListener;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;

import org.jvnet.glassfish.comms.util.LogUtil;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
enum TransactionState {TRYING,
    CALLING,
    PROCEEDING,
    CONFIRMED,
    COMPLETED,
    TERMINATED,
    PENDING,
    ESTABLISHED;

    // ESTABLISHED, state entered after CALLING or PROCEEDING upon 2xx arrival
    // see also TimerRemoveTransaction
}
;
enum TransactionTimer {TimerA,
    TimerB,
    TimerC,
    TimerD,
    TimerE,
    TimerF,
    TimerG,
    TimerH,
    TimerI,
    TimerJ,
    TimerK,
    TimerRemoveTransaction,
    TimerRemove;

    // TimerRemoveTransaction is an extra timer to support RFC 13.2.2.4 2xx
    // Responses, the transaction is removed 64*T1 seconds after the first
    // received 2xx.
}
;


public abstract class Transaction implements GeneralTimerListener {
    public static final String MAGIC_COOKIE = "z9hG4bK";
    protected static TimerServiceImpl _timerService;

    // TODO - UDP transport is defined someother place too i guess
    private final static String _udpTransport = "udp";
    protected static final Logger _log = LogUtil.SIP_LOGGER.getLogger();
    protected static TransactionManager _transactionManager = TransactionManager.getInstance();
    static long T1 = _transactionManager.getTimerT1();
    static long T2 = _transactionManager.getTimerT2();
    static long T4 = _transactionManager.getTimerT4();
    protected TransactionState _state;
    protected String _transactionId;
    private SipServletRequestImpl _request;
    protected boolean _reliableTransport = true;
    private long _transactionStartedTimestamp = 0;
    private long _lastAccessTimestamp = 0;
    protected DialogFragment df;

    public Transaction(String id, TransactionState state,
        SipServletRequestImpl req) {
        if (SipMonitoring.isEnabled(SipMonitoring.TRANSACTION_MANAGER)) {
            _transactionStartedTimestamp = System.currentTimeMillis();

            // We are very careful here not to affect performance:-)
        }

        _transactionId = id;
        _state = state;
        _request = req;
        _request.setTransactionId(id);

        if (_udpTransport.equalsIgnoreCase(req.getTransport())) {
            _reliableTransport = false;
        }

        _timerService = TimerServiceImpl.getInstance();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Created Transaction = " +
                getClass().getName());
        }
    }

    public static String generateBranch() {
        // Generate an UUID
        StringBuilder sb = new StringBuilder(MAGIC_COOKIE).append(UUID.randomUUID()
                                                                      .toString());

        return sb.toString();
    }

    public String getTransactionId() {
        return _transactionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionID = ").append(_transactionId);

        return sb.toString();
    }

    protected void updateLastAccessTimestamp() {
        _lastAccessTimestamp = System.currentTimeMillis();
    }

    protected synchronized void terminate() {
        if (SipMonitoring.isEnabled(SipMonitoring.TRANSACTION_MANAGER)) {
            if (_lastAccessTimestamp == 0) {
                // i.e has reached terminated with no retransmissions and not
                // toCompleted/toConfirmed
                _lastAccessTimestamp = System.currentTimeMillis();
            }

            long transactionTime = _lastAccessTimestamp -
                _transactionStartedTimestamp;
            _transactionManager.recordTransactionTime(transactionTime);

            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "TransactionTime:" + transactionTime);
            }
        }

        clearRequest();
    }

    protected void clearRequest() {
        if (getRequest() != null) {
            df = getRequest().getDialog();
            _request = null;
        }
    }

    DialogFragment getDialog() {
        if (getRequest() != null) {
            return getRequest().getDialog();
        }

        return df;
    }

    protected SipServletRequestImpl getRequest() {
        return _request;
    }

    public long getTransactionStartTime() {
        return _transactionStartedTimestamp;
    }
}
