/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.ssa.utils;

import java.util.StringTokenizer;


/**
 * This is a helper class for parsing different strings.
 *
 * @author edtugdi
 * @since 2005-maj-11
 */
public class ParserHelper {
    /**
     * This method is used for getting the value for a certain parameter
     * @param content - the line to be parsed
     * @param param - parameter to be searched
     * @param delimeter - delimeter
     * @return - the searched value
     */
    public static String getValue(String content, String param, String delimeter) {
        // The parameter can appear in two formats
        // 1. charset="UTF-16", quoted string
        // 2. charset=UTF-16, unquoted string
        StringTokenizer tokens = new StringTokenizer(content, delimeter);
        String value = null;

        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();

            if (token.startsWith(param)) {
                value = token.substring(token.indexOf("=") + 1, token.length());

                break;
            }
        }

        if (value != null) {
            String quote = Character.toString('\u0022');

            if (value.startsWith(quote) && value.endsWith(quote)) {
                return value.substring(1, value.length() - 1);
            } else {
                return value;
            }
        }

        return null;
    }

    /**
     * This method is used to replace an existing parameters value with the newvalue
     * @param content - the line to be parsed
     * @param param - parameter to be searched
     * @param newvalue - the new value for the parameter
     * @param delimeter - delimeter
     * @param quoted - if quoted
     * @return the new content with replaced param
     */
    public static String replaceParam(String content, String param,
        String newvalue, String delimeter, boolean quoted) {
        int index = content.indexOf(param);
        int end = -1;
        index = content.indexOf("=", index) + 1;

        if (quoted) {
            index += 1;
            end = content.indexOf("\"", index);
        } else {
            end = content.indexOf(delimeter, index);

            if (end == -1) {
                end = content.indexOf("\"", index);
            }
        }

        String newcontentype = content.substring(0, index);
        newcontentype += newvalue;

        if (end > 0) {
            newcontentype += content.substring(end, content.length());
        }

        return newcontentype;
    }

    /**
     * This method is used for getting the substring of the content.
     * content.substring(0, content.indexOf(delimeter));
     * @param content - the line to be parsed
     * @param delimeter - delimeter
     * @return the string untill the delimeter or null
     */
    public static String getFirstToken(String content, String delimeter) {
        int i = content.indexOf(delimeter);

        if (i > -1) {
            return content.substring(0, i);
        }

        return null;
    }
}
