/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.ericsson.util.os.linux;

import com.ericsson.util.os.OSUtilSunspecific;

import java.io.FileInputStream;
import java.io.IOException;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * OS util class for the linux operating system.
 *
 * @author ehsroha
 * @since 2006-mar-30
 */
public class OSUtilLinux extends OSUtilSunspecific {
    private static final Logger _log = LogUtil.SIP_LOGGER.getLogger();
    private Double _lastIdle = 0.0;
    private Double _lastTime = 0.0;
    private FileInputStream _file = null;
    private long _lastVisit = 0;
    private int _savedBusy = 0;

    public OSUtilLinux() {
    }

    public String getInfo() {
        return getClass().getName() + ": linux operating system extension";
    }

    public int cpuBusy() {
        long now = System.currentTimeMillis();

        if ((now - _lastVisit) > 1000) {
            _lastVisit = now;

            try {
                byte[] buf = new byte[1024];

                // read /proc/uptime
                if (_file == null) {
                    _file = new FileInputStream("/proc/uptime");
                }

                if (_file.markSupported()) {
                    _file.reset();
                    _file.read(buf);
                } else {
                    _file.read(buf);
                    _file.close();
                    _file = null;
                }

                // get first line an split in to piece
                String[] b = new String(buf).split("[ ]+");

                // value [0] contains uptime
                // value [1] contains idle
                Double new_time = Double.parseDouble(b[0]);
                Double new_idle = Double.parseDouble(b[1]);

                if (_lastTime == 0.0) {
                    _lastTime = new_time;
                    _lastIdle = new_idle;
                    _savedBusy = 0; // overkill :-)

                    return _savedBusy;
                } else {
                    Double busyPercent = 100 -
                        ((100.0 * (new_idle - _lastIdle)) / (new_time -
                        _lastTime));

                    // to make values withing 0.0 >= percent >= 100.0 :-)
                    // only needed if this method is called VERY frequently (i.e.
                    // more than once a second)
                    if (busyPercent < 0) {
                        busyPercent = 0.0;
                    }

                    if (busyPercent > 100) {
                        busyPercent = 100.0;
                    }

                    _lastTime = new_time;
                    _lastIdle = new_idle;
                    _savedBusy = busyPercent.intValue();

                    return _savedBusy;
                }
            } catch (IOException e) {
                _log.log(Level.WARNING, "Error while reading cpu information.",
                    e);

                // return old value...
                return _savedBusy;
            }
        } else {
            return _savedBusy;
        }
    }
}
