/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.Serializable;


/**
 * The SipApplicationRouterInfo class encapsulates the different pieces of
 * information that the application router returns to the container when the
 * container calls the SipApplicationRouter.getNextApplication() method.
 *
 */
public class SipApplicationRouterInfo {
    private String nextApplicationName;
    private String subscriberURI;
    private String route;
    private SipRouteModifier routeModifier;
    private SipApplicationRoutingRegion routingRegion;
    private Serializable stateInfo;

    /**
     * This constructor is used when the next application is local to this
     * container.
     *
     * @param nextApplicationName
     *           The name of the application that the application router selects
     *           to service this request. If no further application is needed in
     *           the current region, this is set to null.
     * @param routingRegion
     * 			The Routing region in which the application that is selected 
     * 			will serve.
     * @param subscriberURI
     *           The URI that the application is selected to serve.
     * @param routingRegion
     *           The route header that could either be an external or internal 
     *           route, the internal route replaces the route popped by the 
     *           container.          
     * @param routeModifier
     *           An enum modifier which qualifies the route returned and the 
     *           router behavior.
     * @param stateInfo
     *           Arbitrary state information of the application router that it
     *           wishes the container to store on its behalf
     */
    public SipApplicationRouterInfo(
		String nextApplicationName,
		SipApplicationRoutingRegion routingRegion,
        String subscriberURI, 
        String route, 
        SipRouteModifier routeModifier, 
        Serializable stateInfo) {
        this.nextApplicationName = nextApplicationName;
        this.routingRegion = routingRegion;
        this.subscriberURI = subscriberURI;
        this.route = route;
        this.routeModifier = routeModifier;
        this.stateInfo = stateInfo;
    }

    /**
     * @return name of next application selected. If isExternal() is true, return
     *         null.
     */
    public String getNextApplicationName() {
        return nextApplicationName;
    }
    
    /**
     * @return Routing region in which the next application is selected to
     * 	serve. If the route is external then this returns null.
     */ 
    public SipApplicationRoutingRegion getRoutingRegion(){
    	return routingRegion;
    }

    /**
     * @return A SIP Route, if external is to be used by the container to route
     * 	the request to the external entity. The internal route indicates the 
     * 	route which led the request to the container. This internal route is not
     * 	used for any routing purposes but to let application router potentially
     * 	modify the route popped by the container.
     */
    public String getRoute() {
    	return route; //TODO change to String[], JSR update pending
    }
    
    public SipRouteModifier getRouteModifier(){
    	return routeModifier;
    }
    
    /**
     * @return URI of the subscriber whom the next application is selected to
     *         serve. If isExternal() is true, return null.
     */
    public String getSubscriberURI() {
        return subscriberURI;
    }
    
    /**
     * @return router state information
     */
    public Serializable getStateInfo() {
        return stateInfo;
    }

}
