/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.util.EventListener;

/**
 * Objects that are bound to a SipApplicationSession may listen to
 * container events notifying them when the application session to which
 * they are bound will be passivated or activated. A container that
 * migrates application sessions between VMs or persists them is required
 * to notify all attributes implementing this listener and that are bound
 * to those application sessions of the events.
 *
 * @since 1.1
 */
public interface SipApplicationSessionActivationListener
        extends EventListener {

    /**
     * Notification that the application session is about to be passivated.
     *
     * @param se event identifying the application session about to be
     * persisted
     */
    public void sessionWillPassivate(SipApplicationSessionEvent se);

    /**
     * Notification that the application session has just been activated.
     *
     * @param se event identifying the activated application session
     */
    public void sessionDidActivate(SipApplicationSessionEvent se);
}
