/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.util.EventListener;

/** 
 * Implementations of this interface can receive notifications about
 * invalidated and/or activated SipApplicationSession objects in the SIP
 * application they are part of. To receive notification events, the
 * implementation class must be configured in the deployment descriptor
 * for the servlet application.
 */
public interface SipApplicationSessionListener extends EventListener {

    /**
     * Notification that a session was created.
     *
     * @param ev the notification event
     */
    void sessionCreated(SipApplicationSessionEvent ev);

    /**
     * Notification that a session was invalidated. Either it timed
     * out or it was explicitly invalidated. It is not possible to extend the
     * application sessions lifetime.
     *
     * @param ev the notification event
     */
    void sessionDestroyed(SipApplicationSessionEvent ev);

    /**
     * Notification that an application session has expired. The
     * application may request an extension of the lifetime of the
     * application session by invoking SipApplicationSession.setExpires(int).
     *
     * @param ev the notification event
     */
    void sessionExpired(SipApplicationSessionEvent ev);
}
