/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.netbeans.sip.module.catalog;

import java.util.logging.Logger;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 * Catalog for SIP DTD.
 *
 * @author Ludo
 */

public class SIPCatalog implements CatalogReader, CatalogDescriptor, org.xml.sax.EntityResolver {

    public static final String SIP_ID_1_0 = "-//Java Community Process//DTD SIP Application 1.0//EN"; // NOI18N
    public static final String SIP_ID_1_1 = "http://www.jcp.org/xml/ns/sipservlet" + "/" + "sip-app_1_1.xsd"; //NO18N

    private static final String URL_SIP_1_0 ="jar:nbinst:///modules/ext/sip/ssa-api.jar!/sip-app_1_0.dtd"; // NOI18N
    private static final String URL_SIP_1_1 ="jar:nbinst:///modules/ext/sip/ssa-api.jar!/sip-app_1_1.xsd"; // NOI18N

    /**
     * Creates a new instance of SIPCatalog
     */
    public SIPCatalog() {
    }

    /**
     * Get String iterator representing all public IDs registered in catalog.
     * @return null if cannot proceed, try later.
     */
    public java.util.Iterator getPublicIDs() {
        java.util.List<String> list = new java.util.ArrayList<String>();
        boolean add = list.add(SIP_ID_1_0);
        String f2a = "Failed to add ";      // NOI18N
        if (!add) {
            Logger.getLogger(SIPCatalog.class.getName()).finest(f2a+
                    SIP_ID_1_0);
        }
        add = list.add(SIP_ID_1_1);
        if (!add) {
            Logger.getLogger(SIPCatalog.class.getName()).finest(f2a+
                    SIP_ID_1_1);
        }

        return list.listIterator();
    }

    /**
     * Get registered systemid for given public Id or null if not registered.
     * @return null if not registered
     */
    public String getSystemID(String publicId) {
        if (SIP_ID_1_0.equals(publicId))
            return URL_SIP_1_0;
        else if (SIP_ID_1_1.equals(publicId))
            return URL_SIP_1_1;
        else
            return null;
    }

    /**
     * Refresh content according to content of mounted catalog.
     */
    public void refresh() {
        // intentional
    }

    /**
     * Optional operation allowing to listen at catalog for changes.
     * @throws UnsupportedOpertaionException if not supported by the implementation.
     */
    public void addCatalogListener(CatalogListener l) {
        // intentional
    }
    
    /**
     * Optional operation couled with addCatalogListener.
     * @throws UnsupportedOpertaionException if not supported by the implementation.
     */
    public void removeCatalogListener(CatalogListener l) {
        // intentional
    }
    
    /** Registers new listener.  */
    public void addPropertyChangeListener(java.beans.PropertyChangeListener l) {
        // intentional
    }
    
     /** Unregister the listener.  */
    public void removePropertyChangeListener(java.beans.PropertyChangeListener l) {
        // intentional
    }
    
    /**
     * @return I18N display name
     */
    public String getDisplayName() {
        return NbBundle.getMessage (SIPCatalog.class, "LBL_SIPCatalog");  //NOI18N
    }
    
    /**
     * Return visuaized state of given catalog.
     * @param type of icon defined by JavaBeans specs
     * @return icon representing current state or null
     */
    public java.awt.Image getIcon(int type) {
        return Utilities.loadImage("org/netbeans/modules/sun/sip/catalog/SIPIcon.gif"); // NOI18N
    }
    
    /**
     * @return I18N short description
     */
    public String getShortDescription() {
        return NbBundle.getMessage (SIPCatalog.class, "DESC_SIPCatalog");     //NOI18N
    }
    
   /**
     * Resolves schema definition file for SIP
     * @param publicId publicId for resolved entity (null in our case)
     * @param systemId systemId for resolved entity
     * @return InputSource for publisId, 
     */    
    public org.xml.sax.InputSource resolveEntity(String publicId, String systemId) throws org.xml.sax.SAXException, java.io.IOException {
       if (SIP_ID_1_0.equals(publicId)) {
            return new org.xml.sax.InputSource(URL_SIP_1_0);
        }   else if (SIP_ID_1_1.equals(publicId)) {
            return new org.xml.sax.InputSource(URL_SIP_1_1);
        }   else {
            return null;
        }
    }
    
    /**
     * Get registered URI for the given name or null if not registered.
     * @return null if not registered
     */
    public String resolveURI(String name) {
        return null;
    }

    /**
     * Get registered URI for the given publicId or null if not registered.
     * @return null if not registered
     */ 
    public String resolvePublic(String publicId) {
        return null;
    }
}


