/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.netbeans.sip.module.wizards;

import java.io.File;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ProjectIterator implements TemplateWizard.Iterator {
    
    private static final long serialVersionUID = 5L;
    
    private int currentIndex;
    private transient ProjectConfigPanel basicPanel;
    private transient WizardDescriptor wiz;

    static Object create() {
        return new ProjectIterator();
    }
    
    private ProjectIterator () {
    }
    
    public void addChangeListener (javax.swing.event.ChangeListener changeListener) {
        // intentional
    }
    
    public void removeChangeListener (javax.swing.event.ChangeListener changeListener) {
        // intentional 
    }
    
    public org.openide.WizardDescriptor.Panel<WizardDescriptor> current () {
        return basicPanel;
    }
    
    public boolean hasNext () {
        return false;
    }
    
    public boolean hasPrevious () {
        return false;
    }
    
    public void initialize (org.openide.loaders.TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        String name = templateWizard.getTemplate().getNodeDelegate().getDisplayName();
        if (name != null) {
            name = name.replaceAll(" ", ""); //NOI18N
        }
        templateWizard.putProperty (ProjectWizardProperties.NAME, name);
        basicPanel = new ProjectConfigPanel();
        currentIndex = 0;
        updateStepsList ();
    }
    
    public void uninitialize (org.openide.loaders.TemplateWizard templateWizard) {
        basicPanel = null;
        this.wiz.putProperty(ProjectWizardProperties.PROJECT_DIR,null);
        this.wiz.putProperty(ProjectWizardProperties.NAME,null);
        currentIndex = -1;
    }
    
    public java.util.Set<DataObject> instantiate (org.openide.loaders.TemplateWizard templateWizard) throws java.io.IOException {
        File projectLocation = (File) wiz.getProperty(ProjectWizardProperties.PROJECT_DIR);
        String name = (String) wiz.getProperty(ProjectWizardProperties.NAME);
                        
        FileObject prjLoc = ProjectGenerator.createProjectFromTemplate(templateWizard.getTemplate().getPrimaryFile(), projectLocation, name);
        
        FileObject webRoot = prjLoc.getFileObject("web");    //NOI18N
        FileObject index = getIndexFile(webRoot);

        Set<DataObject> hset = new HashSet<DataObject>();
        hset.add(DataObject.find(prjLoc));
        hset.add(DataObject.find(index));
        
        return hset;
    }
    
    public String name() {
        return current().getComponent().getName();
    }
    
    public void nextPanel() {
        throw new NoSuchElementException ();
    }
    
    public void previousPanel() {
        throw new NoSuchElementException ();
    }
    
    void updateStepsList() {
        JComponent component = (JComponent) current ().getComponent ();
        if (component == null) {
            return;
        }
        String[] list;
        list = new String[] {
            NbBundle.getMessage(ProjectIterator.class, 
                    "LBL_NWP1_ProjectTitleName"),                           // NOI18N
        };
        component.putClientProperty ("WizardPanel_contentData", list);      // NOI18N
        component.putClientProperty ("WizardPanel_contentSelectedIndex",    // NOI18N
                Integer.valueOf(currentIndex));
    }
    
    private FileObject getIndexFile(final FileObject webRoot) {
        FileObject file = webRoot.getFileObject("index", "jsp");        // NOI18N
        if (file == null) {
            file = webRoot.getFileObject("index", "html");              // NOI18N
        }
        return file;
    }
    
    private void readObject(final java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
        basicPanel = new ProjectConfigPanel();        
    }
}
