/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.netbeans.sip.module.wizards;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SipListenerWizardPanel1 implements WizardDescriptor.Panel {

    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private SipListenerVisualPanel1 component;
    private WizardDescriptor wiz;
    
    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public SipListenerVisualPanel1 getComponent() {
        if (component == null) {
            component = new SipListenerVisualPanel1(this);
        }
        return component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SipListenerWizardPanel1.class); 
    }

    public boolean isValid() {
        boolean retVal = getComponent().getInterfaces().length > 0;
        if (wiz != null && !retVal) {
            wiz.putProperty("WizardPanel_errorMessage",
                    NbBundle.getMessage(SipListenerWizardPanel1.class,
                    "ERR_MustSelectInterface"));                               //NOI18N
        }
        if (wiz != null && retVal) {
            Iterator iter = Arrays.asList(getComponent().getInterfaces()).iterator();
            StringBuffer interfacesValue = new StringBuffer();
            while (iter.hasNext()) {
                String i = (String) iter.next();
                interfacesValue.append(i);
                if (iter.hasNext()) {
                    interfacesValue.append(",\n\t");
                }
            }
            wiz.putProperty("interfaces", interfacesValue);
        }

        return retVal;
    }
    
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1); // or can use ChangeSupport in NB 6.0

    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }

    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }

    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }


    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {
        wiz = (WizardDescriptor) settings;
    }

    public void storeSettings(Object settings) {
    }

    void viewChanged() {
        fireChangeEvent();
    }
}

