/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
* Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
*/

package org.jvnet.glassfish.comms.ant;

import javax.swing.SwingUtilities;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jvnet.glassfish.comms.sipagent.ui.SipAgentMainWindow;
import org.openide.windows.TopComponent;

/**
 * @author vkraemer
 */
public class TestAgent extends Task {
    
    private String name=null;
    
    public void setName(String s) {
        name = s;
    }

    public void execute() throws BuildException {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                TopComponent taw;
                if (null == name || name.startsWith("${")) {
                    taw = new SipAgentMainWindow(1);
                } else {
                    taw = SipAgentMainWindow.get(name);
                }
                taw.requestActive();
            }
        });
    }

}
