/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.actions;

import org.jvnet.glassfish.comms.sipagent.ui.SipAgentMainWindow;
import org.netbeans.api.project.Project;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class SipAgentCookieAction extends CookieAction {
    
    private int nrOfAgents = 0;
    
    protected void performAction(Node[] activatedNodes) {
        SipAgentMainWindow sa = new SipAgentMainWindow(nrOfAgents);
        nrOfAgents++;
        sa.requestActive();
    }

    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }

    public String getName() {
        return NbBundle.getMessage(SipAgentCookieAction.class, 
            "CTL_SipAgentCookieAction");
    }

    protected Class[] cookieClasses() {
        return new Class[]{Project.class};
    }

    @Override
    protected String iconResource() {
        return "org/jvnet/glassfish/comms/sipagent/actions/bd.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }
}
