/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.backend;

import org.jvnet.glassfish.comms.sipagent.model.ModelListener;
import org.jvnet.glassfish.comms.sipagent.model.SipMessage;
import org.jvnet.glassfish.comms.sipagent.model.SipRequest;
import org.jvnet.glassfish.comms.sipagent.model.SipResponse;
import org.jvnet.glassfish.comms.sipagent.support.Constants;

/**
 * Controller interface for sending and receiving SIP messages. 
 * 
 * 
 * @author elnyvbo
 */
public interface Controller {
    
    /**
     * do some initialization, e.g. setup socket connection to backend. A 
     * Constants object can be passed in for reading out things like port nrs.
     */
    public void init(Constants aConstants);
    
    /**
     *  Create a new SIP Request template in the model.
     *  Default values could already be filled in e.g. Call ID.
     */
    public SipRequest createRequest();
    
    /**
     *  Create a new SIP Request based on String and 
     *  use default values where necessary.
     *
     *  The returned SipMessage can be further manipulated 
     *  and then passed on to the sendMessage() method. 
     *
     *  @throws BackendException if the SipRequest cannot be produced for some
     *          reason e.g. parsing problems.
     */
    public SipRequest createRequest(String aBunchOfText) 
        throws BackendException;
    
    /**
     *  Create a new SIP Response template in the model. 
     */
    public SipResponse createResponse();
    
    /**
     *  Create a new SIP Response based on String and 
     *  use default values where necessary.
     *
     *  The returned SipMessage can be further manipulated 
     *  and then passed on to the sendMessage() method. 
     *  
     * @throws BackendException if the SipResponse cannot be produced for some
     *          reason e.g. parsing problems.
     */
    public SipResponse createResponse(String aBunchOfText) 
        throws BackendException;
    
    /**
     *  Sends a SIP Message 
     */
    public void sendMessage(SipMessage aMessage);
    
    /**
     *  Register a modellistener which listens for changes to the model e.g. 
     *  when a response is received.
     */
    public void registerListener(ModelListener aListener);
    
    

    public void close();
}
