/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.sipagent.backend;

import java.util.logging.Level;
import org.jvnet.glassfish.comms.sipagent.support.Constants;
import java.util.logging.Logger;

/**
 *  Singleton factory for creating a backend controller. The backend controller
 *  that is returned, can be specified as a system property (See Constants).
 *
 * @author elnyvbo
 */
public class ControllerFactory {
    
     private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.backend.ControllerFactory");
    
    private static volatile ControllerFactory theirInstance = null;
    
    /**
     * Returns the ControllerFactory singleton instance
     */
    public static ControllerFactory instance()
    {
        if (theirInstance == null){
            theirInstance = new ControllerFactory();
        }
        return theirInstance;
    }
    
    /**
     * Creates a new instance of ControllerFactory
     */
    private ControllerFactory() {
    }
    
    public Controller createController(Constants aConstants)
    {
        Controller controllerInstance = null;
        try
        {
            Class clazz = Class.forName(
                aConstants.getProperty(Constants.CONTROLLER_CLASS));
            controllerInstance = (Controller)clazz.newInstance();
            controllerInstance.init(aConstants);
            return controllerInstance;
        } catch (ClassNotFoundException cnfe) {
            theirLogger.log(Level.FINER,null,cnfe);
        } catch (InstantiationException ie) {
            theirLogger.log(Level.FINER,null,ie);            
        } catch (IllegalAccessException iae) {
            theirLogger.log(Level.FINER,null,iae);            
        } catch (RuntimeException re) {
            theirLogger.log(Level.FINER,null,re);            
        }
        return controllerInstance;
    }
}
