/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.sipagent.model;

import com.ericsson.ssa.sip.SipServletMessageImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *  Small wrapper class for SipServletMessageImpls. SipMessage represents the
 *  data object that the GUI operates on. It could be extended to include e.g.
 *  representation data.
 *
 *  Reuse of the ssa message impl implicates that we cannot modify system
 *  headers, which is a shame the user should of course be able to specify 
 *  these headers (From, To, etc.). 
 *
 *  To construct new SipMessages, use the MySipParser instead.
 *
 *  @author elnyvbo
 */
public abstract class SipMessage {
   
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.model");
   
    protected SipServletMessageImpl itsImpl = null;
    
    public void setImpl(SipServletMessageImpl anImpl) {
        itsImpl = anImpl;
    }
    
    public SipServletMessageImpl getImpl() {
        return itsImpl;
    }
    
    public String getFromName(){
        return itsImpl.getFrom().getDisplayName();
    }
    public String getFromURI(){
        return itsImpl.getFrom().getURI().toString();
    }
    public String getToName(){
        return itsImpl.getTo().getDisplayName();
    }
    public String getToURI(){
        return itsImpl.getTo().getURI().toString();
    }
    
    public String getToTag() {
        return itsImpl.getTo().getParameter("tag");
    }
    
    public String getFromTag() {
        return itsImpl.getFrom().getParameter("tag");
    }
    
    public String getMethod(){
        return itsImpl.getMethod();
    }
    
    public String getContent(){
        String result = "";
        try {
            Object o = itsImpl.getContent();
            if (o==null){
                result = "";
            }
            else{
                result = o.toString();
            }
        }
        catch (IOException e){
            theirLogger.log(Level.SEVERE,"could not read content from message!",e);
        }
        return result;
    }
    
    public String toString(){
        return itsImpl.toString();
    }
}
