/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.model;

import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import javax.servlet.sip.SipURI;

/**
 *  Don't create SipRequests directly, always use the parser.
 *
 * @author elnyvbo
 */
public class SipRequest extends SipMessage {
    
    
    /**
     *  package private constructor
     */
    SipRequest(){
        super();
    }
    
    public String getURI(){
        return ((SipURI)((SipServletRequestImpl)itsImpl).getRequestURI()).toString();
    }
    
    /**
     *  may throw ClassCastException if impl is of wrong type
     */
    @Override
    public void setImpl(SipServletMessageImpl anImpl) {        
        itsImpl = (SipServletRequestImpl)anImpl;
    }
}
