/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.support;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author elnyvbo
 */
public class Constants {
    
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.support.Constants");
    
    // SIP Request Methods
    public static final String INVITE = "INVITE";
    public static final String REGISTER = "REGISTER";
    public static final String BYE = "BYE";
    public static final String ACK = "ACK";
    public static final String CANCEL = "CANCEL";
    public static final String INFO = "INFO";
    public static final String MESSAGE = "MESSAGE";
    public static final String OPTIONS = "OPTIONS";
    public static final String PUBLISH = "PUBLISH";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String NOTIFY = "NOTIFY";
    public static final String UPDATE = "UPDATE";
    
    // SIP Reason Phrases
    public static final String OK = "OK";
    
    // SIP Headers
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ALERT_INFO = "Alert-Info";
    public static final String ALLOW = "Allow";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CALL_ID = "Call-ID";
    public static final String CALL_INFO = "Call-Info";
    public static final String CONTACT = "Contact";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CSEQ = "Cseq";
    public static final String DATE = "Date";
    public static final String ERROR_INFO = "Error-Info";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String IN_REPLY_TO = "In-Reply-To";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String MIME_VERSION = "MIME-Version";
    public static final String MIN_EXPIRES = "Min-Expires";
    public static final String ORGANIZATION = "Organization";
    public static final String PRIORITY ="Priority";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String RECORD_ROUTE = "Record-Route";
    public static final String REPLY_TO = "Reply-To";
    public static final String REQUIRE = "Require";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String ROUTE = "Route";
    public static final String SERVER = "Server";
    public static final String SUBJECT = "Subject";
    public static final String SUPPORTED = "Supported";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TO = "To";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String USER_AGENT  = "User-Agent";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    
    // Miscellaneous constants used throughout the code
    public static final String CRLF = "\r\n";
    public static final String SIP_CHARSET = "UTF-8";
    public static final String PROTOCOL_LINE = "SIP/2.0";
    public static final String SIP_URI_PROTOCOL = "sip";
    public static final String HTTP_URI_PROTOCOL = "http";
    public static final String MAILTO_URI_PROTOCOL = "mailto";
    public static final String SIPS_URI_PROTOCOL = "sips";
    public static final String TEL_URI_PROTOCOL = "tel";
    public static final String UDP = "UDP";
    public static final String TCP = "TCP";

    // System properties
    public static final String CONTROLLER_CLASS = "controllerclass";
    public static final String HOST = "hostname";
    public static final String PORT = "port";
    public static final String LOCAL_HOST = "localhost";
    public static final String LOCAL_PORT = "localport";
    public static final String LOGGING_CONFIGURATION_FILE = "logconfigfile";
    public static final String AGENT_NAME = "agentname";
    public static final String LOG_FILE = "logfilename";
    public static final String TRANSPORT = "transport";
    public static final String TRAFFIC_LOGGING_ENABLED = "trafficlogging";
    
    // System property defaults
    private static final String CONTROLLER_CLASS_DEFAULT = 
            "org.jvnet.glassfish.comms.sipagent.backend.SocketController";
    private static final String HOST_DEFAULT = "127.0.0.1";
    private static final String PORT_DEFAULT = "5060";
    private static final String LOCAL_HOST_DEFAULT = "127.0.0.1";
    private static final String LOCAL_PORT_DEFAULT = "6060";
    private static final String LOGGING_CONFIGURATION_FILE_DEFAULT = 
            "sipclient.properties";
    private static final String AGENT_NAME_DEFAULT = "SIP Test Agent";
    private static final String LOG_FILE_DEFAULT = "siptestagent.log";
    private static final String TRANSPORT_DEFAULT = "UDP";
    private static final String TRAFFIC_LOGGING_ENABLED_DEFAULT = "true";
    
    private HashMap<String, String> theirProps =
        new HashMap<String, String>();
    private static HashMap<String, String> theirDefaults = 
        new HashMap<String, String>();
//
//    static {
//        reset();
//    }
//    
    
    // constructor
    public Constants(){
        reset();
    }
    
    /**
     *  return property value or null. lookup property value in the cache, if 
     *  not present check system property and cache that. if still not present,
     *  use the default. If no default defined, return null.
     */
    public String getProperty(String aProperty)
    {
        // try to retrieve from cache
        String value = theirProps.get(aProperty);
        if ("".equals(value) || (value == null)) {
            // try to retrieve from system
            value = System.getProperty(aProperty);
            if ("".equals(value) || (value == null)) {
                // use the default, if any
                value = theirDefaults.get(aProperty);
            }
        }
        // cache current value
        theirProps.put(aProperty, value);
        return value;
    }
    
    /**
     * could be used to e.g. change default proxy IP address. Returns the
     * previous value, if any. 
     */
    public String setProperty(String aProperty, String aValue)
    {
        theirLogger.finer("Property " + aProperty + " now set to " + aValue);
        return (String)theirProps.put(aProperty, aValue);
    }
    
    /**
     * used to reset to default configuration settings
     */
    public void reset(){
        // reset to defaults
        try 
        {
            String host = InetAddress.getLocalHost().getHostAddress();
            theirDefaults.put(LOCAL_HOST, host);
        }
        catch (IOException e){
            theirDefaults.put(LOCAL_HOST, LOCAL_HOST_DEFAULT);
            theirLogger.log(Level.FINEST,"failed to get host address. using default",e);
        }
        theirDefaults.put(CONTROLLER_CLASS, CONTROLLER_CLASS_DEFAULT);
        theirDefaults.put(HOST, HOST_DEFAULT);
        theirDefaults.put(PORT, PORT_DEFAULT);
        theirDefaults.put(LOCAL_PORT, LOCAL_PORT_DEFAULT);
        theirDefaults.put(
            LOGGING_CONFIGURATION_FILE, LOGGING_CONFIGURATION_FILE_DEFAULT);
        theirDefaults.put(AGENT_NAME, AGENT_NAME_DEFAULT);
        theirDefaults.put(LOG_FILE, LOG_FILE_DEFAULT);
        theirDefaults.put(TRANSPORT, TRANSPORT_DEFAULT);
        theirDefaults.put(
            TRAFFIC_LOGGING_ENABLED, TRAFFIC_LOGGING_ENABLED_DEFAULT);
    }
    
    public String dummyRequest(){
        final String TIME = "" + System.currentTimeMillis();
        final String HOST = getProperty(LOCAL_HOST);
        final String PORT = getProperty(LOCAL_PORT);
        final String FROMTAG = ";tag=" + TIME;
        String dummy = 
            "REGISTER sip:Alice@" + HOST + " SIP/2.0" + CRLF
            + CONTACT + ": sip:" + HOST + ":" + PORT 
            + ";transport=" + getProperty(TRANSPORT) + CRLF
            + CSEQ + ": 42 REGISTER" + CRLF
            + VIA + ": SIP/2.0/" + getProperty(TRANSPORT) 
            + " " + HOST + ":" + PORT 
            + ";branch=z9hG4bK-" + TIME + CRLF
            + MAX_FORWARDS + ": 70" + CRLF
            + CONTENT_LENGTH + ": 11" + CRLF
            + CONTENT_TYPE + ": text/html" + CRLF
            + CALL_ID + ": C" + TIME + CRLF
            + TO + ": \"Alice\" <sip:Alice@" + HOST + ">" + CRLF
            + FROM + ": \"Alice\" <sip:Alice@" + HOST + ">" + FROMTAG + CRLF
            + CRLF 
            + "Hello World";
        return dummy;
    }
}
