/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.transport;

import org.jvnet.glassfish.comms.sipagent.model.SipMessage;
import java.net.InetAddress;
import java.util.logging.Logger;

/**
 *  Abstract base class for socket handlers which allows the user to specify
 *  local and remote port, and local and remote host address.
 *
 *  Every SocketHandler will attempt max 50 retries when a connection dies,
 *  starting at the local port specified by the usser, and incrementing by 1
 *  with each retry.
 *
 *  A SocketHandler should implement the listen() method and the sendMessage()
 *  method. The listen method is called in an infinite while loop when the
 *  SocketHandler is started (Runnable).
 *
 */
public abstract class SocketHandler extends SocketTransportListenerManager
        implements Runnable {
    private static Logger theirLogger =
            Logger.getLogger("org.jvnet.glassfish.comms.sipagent.transport.SocketHandler");
    
    public SocketHandler(InetAddress inetaddress, int i, InetAddress inetaddress1, int j) {
        running = false;
        localHost = inetaddress;
        localPort = i;
        remoteHost = inetaddress1;
        remotePort = j;
        
        theirLogger.finer(
                "Created sockethandler (" +
                inetaddress + ":" + i + ", " +
                inetaddress1 + ":"+ j+")");
    }
    
    public void run() {
        int i = 0;
        running = true;
        do
        {
            if(!running || i >= 50)
                break;
            try {
                listen();
            } catch(Exception _ex) {
                if(running) {
                    localPort++;
                    i++;
                }
            }
        } while(true);
    }
    
    public void stop() {
        running = false;
        try {
            closeSocket();
            return;
        } catch(Exception _ex) {
            return;
        }
    }
    
    public boolean isRunning() {
        return running;
    }
    
    public int getListeningPort() {
        return localPort;
    }
    
    protected abstract void closeSocket()
    throws Exception;
    
    protected abstract void listen()
    throws Exception;
    
    public abstract void sendMessage(SipMessage sipmessage)
    throws Exception;
    
    protected boolean running;
    protected InetAddress localHost;
    protected int localPort;
    protected InetAddress remoteHost;
    protected int remotePort;
    protected final int MAX_CONNECTION_RETRY = 50;
}
