/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.sipagent.transport;

import org.jvnet.glassfish.comms.sipagent.model.MySipParser;
import org.jvnet.glassfish.comms.sipagent.model.SipMessage;
import org.jvnet.glassfish.comms.sipagent.model.SipRequest;
import org.jvnet.glassfish.comms.sipagent.support.LogSupport;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/**
 *  SocketTransportListenermanager offers methods for listening to events on a
 *  socket interface. The fireIncomingeMessage method can be used by a subclass 
 *  when data arrives on the socket. The fireOutgoingMessage method can be used
 *  when data was sent.
 *
 *  After a SocketTransportListenerManager has been created, users should call
 *  the setTransportListenerList method to specify the specific List object that
 *  should be used for maintaining a list of transportListeners.
 *
 *  the fire...Message methods are proxy methods which will in turn invoke the 
 *  corresponding messageReceived or messageSent methods for each of the 
 *  TransportListeners.
 */ 
public class SocketTransportListenerManager
{
    protected List<TransportListener> itsListeners;
    
    private static Logger theirLogger = 
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.transport");
    
    public SocketTransportListenerManager()
    {
    }

    public void addListener(TransportListener transportlistener)
    {
        itsListeners.add(transportlistener);
    }

    public void removeListener(TransportListener transportlistener)
    {
        itsListeners.remove(transportlistener);
    }

    public void setTransportListenerList(List<TransportListener> list)
    {
        if(itsListeners != null)
            itsListeners.clear();
        itsListeners = list;
    }

    protected void fireIncomingMessage(
            String aTransport, 
            String aHost, 
            int aPort, 
            String aBuffer)
    {
        
        theirLogger.finer(
            "aTransport: " + aTransport + 
            ", aHost: " + aHost + 
            ", aPort: " + aPort +
            ", aBuffer: " + aBuffer);
        
        ByteBuffer bb = ByteBuffer.wrap(aBuffer.getBytes());
        
        SipMessage result = null;
        try
        {
            MySipParser p = MySipParser.getInstance();
            // TODO apparently passing in a bunch of nulls works fine!
            result = p.parseMessage(null, bb, null, null, null);
        }
        catch (Exception e)
        {
            theirLogger.severe("Failed parsing incoming buffer:\n" + 
                LogSupport.stringify(e));
        }
        
        for(Iterator iterator = itsListeners.iterator(); 
            iterator.hasNext(); 
            ((TransportListener)iterator.next()).messageReceived(result));
    }

    protected void fireOutgoingMessage(SipMessage aMessage)
    {
        for(int i = 0; i < itsListeners.size(); i++)
            ((TransportListener)itsListeners.get(i)).messageSent(aMessage);
    }
}
