/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.ui;

import javax.swing.event.DocumentEvent;
import org.jvnet.glassfish.comms.sipagent.support.Constants;
import org.jvnet.glassfish.comms.sipagent.support.LogSupport;
import java.awt.CardLayout;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 * This class represents the actual GUI. It could be reused outside of
 * NetBeans. The AgentMailPanel contains a bottom panel and three top panels in
 * a card layout: a MainPanel (shown at startup), a Request Edit panel, and
 * a response edit Panel.
 *
 * All communication with the backend and the model is handled by itsAgent.
 * Any manipulations to model objects are delegated to the agent.
 *
 * AgentMainJPanel offers a few package private methods, mainly intended to be
 * used by the agent for updating parts of the screen. When a new message is
 * received, the message history panel should be updated.
 *
 * Panel is organised by a CardLayout containing three panels. The main panel
 * shows a request in String format. When the user hits "send", the text is
 * parsed by the agent and sent to the backend.
 *
 * in the request or response edit panel, changes can be made using any of the
 * controls on the left e.g. by adding/removing headers, changing method names
 * etc.
 *
 * user operates on a local bean object representing the request or response.
 * When the edit window closes, the request or response is stringified and shown
 * in the main panel. The user can then make further manual changes (adding
 * tags, etc.)
 *
 * When editing is done, user presses 'send' and the text is sent to the back-
 *  end as is.
 *
 * @author  elnyvbo
 */
public class AgentMainJPanel extends javax.swing.JPanel {

    // ID is remembered to give each test agent panel its own 
    // local port number and agent name.
    private int itsID = 0;
    
    // panel-scoped constants
    private Constants itsConstants = null;
    
    // java.util.logging object
    private static Logger theirLogger = null;

    // agent handles interface to backend
    private ControllerAgent itsAgent = null;

    // MessageBeans hold data from Request- and Response- edit panels
    private RequestBean itsRequestBean = null;
    private ResponseBean itsResponseBean = null;

    // Listeners for propagating user modifications to the beans
    private HeaderTableListener itsRequestHeaderTableListener = null;
    private HeaderTableListener itsResponseHeaderTableListener = null;

    // whether or not to limit the display of incoming/outging messsages.
    private final int HISTORY_UNLIMITED = -1;
    private int itsHistoryLimit = HISTORY_UNLIMITED;

    /**
     * Creates new form AgentMainJPanel. Initializes communication with the
     * backend as well as the graphical components. Call initAgent after 
     * construction!
     */
    public AgentMainJPanel(int anInstanceNr) {
        itsID = anInstanceNr;
        itsConstants = new Constants();
        
        initComponents();
        // fix the table model headers... which would be hard coded otherwise
        itsMessageHistory.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                NbBundle.getMessage(AgentMainJPanel.class, "HDR_MESSAGE")
            }
        ));
        
        String tmp = NbBundle.getMessage(AgentMainJPanel.class, "HDR_NAME");
        itsRequestHeadersTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                tmp,
                NbBundle.getMessage(AgentMainJPanel.class, "HDR_VALUE")
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        itsRequestHeadersTable.setColumnSelectionAllowed(true);
        TableColumn nameColumn2 = itsRequestHeadersTable.getColumn(tmp);
        nameColumn2.setCellEditor(new DefaultCellEditor(new HeaderComboBox()));

        itsResponseHeadersTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                tmp,
                NbBundle.getMessage(AgentMainJPanel.class, "HDR_VALUE")
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        TableColumn nameColumn = itsResponseHeadersTable.getColumn(tmp);
        nameColumn.setCellEditor(new DefaultCellEditor(new HeaderComboBox()));
        
        LogSupport.initLogging(itsConstants);
        theirLogger = Logger.getLogger(
            "org.jvnet.glassfish.comms.sipagent.ui.AgentMainJPanel");
        this.initConfiguration();
        this.initAgent();
        itsCreationTextArea.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButton")); // NOI18N
                } else {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButtonOTHER")); // NOI18N
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButton")); // NOI18N
                } else {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButtonOTHER")); // NOI18N
                }
            }

            public void changedUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButton")); // NOI18N
                } else {
                    org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButtonOTHER")); // NOI18N
                }
            }
            
        });
    }
    
    private void initAgent() {
        theirLogger.fine("Initializing proxy agent");
        if (itsAgent != null) {
            itsAgent.close();
            itsAgent = null;
        }
        itsAgent = new ControllerAgent(this, itsConstants);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        itsHistoryPopup = new javax.swing.JPopupMenu();
        itsRemoveMessageMenuItem = new javax.swing.JMenuItem();
        itsClearHistoryMenuItem = new javax.swing.JMenuItem();
        itsFileDialog = new javax.swing.JDialog();
        itsFileChooser = new javax.swing.JFileChooser();
        itsInfoDialog = new javax.swing.JDialog();
        itsInfoOptionPane = new javax.swing.JOptionPane();
        jScrollPane3 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        itsTopPanel = new javax.swing.JPanel();
        itsMainPanel = new javax.swing.JPanel();
        itsCreationPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        itsCreationTextArea = new javax.swing.JTextArea();
        itsNewRequestButton = new javax.swing.JButton();
        itsSendButton = new javax.swing.JButton();
        itsHistoryPanel = new javax.swing.JPanel();
        itsAckButton = new javax.swing.JButton();
        itsByeButton = new javax.swing.JButton();
        itsCancelButton = new javax.swing.JButton();
        itsRequestButton = new javax.swing.JButton();
        its200OKButton = new javax.swing.JButton();
        itsResponseButton = new javax.swing.JButton();
        itsCopyMessageButton = new javax.swing.JButton();
        messageHistoryScollPane = new javax.swing.JScrollPane();
        itsMessageHistory = new javax.swing.JTable();
        itsHistoryLimitCheckBox = new javax.swing.JCheckBox();
        itsHistoryLimitField = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        itsSelectedMessagePane = new javax.swing.JTextPane();
        itsRequestEditPanel = new javax.swing.JPanel();
        itsRequestPreviewPane = new javax.swing.JScrollPane();
        itsRequestPreviewTextArea = new javax.swing.JTextArea();
        itsRequestContentPane = new javax.swing.JScrollPane();
        itsRequestContentTextArea = new javax.swing.JTextArea();
        itsRequestPanel = new javax.swing.JPanel();
        requestMethodComboBoxLabel = new javax.swing.JLabel();
        itsRequestMethodComboBox = new javax.swing.JComboBox();
        requestUriFieldLabel = new javax.swing.JLabel();
        itsRequestUriTextField = new javax.swing.JTextField();
        itsRequestFromPanel = new javax.swing.JPanel();
        requestFromnameFieldLabel = new javax.swing.JLabel();
        requestFromUriFieldLabel = new javax.swing.JLabel();
        itsRequestFromNameTextField = new javax.swing.JTextField();
        itsRequestFromUriTextField = new javax.swing.JTextField();
        itsRequestToPanel = new javax.swing.JPanel();
        requestToNameFieldLabel = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        itsRequestToNameTextField = new javax.swing.JTextField();
        itsRequestToUriTextField = new javax.swing.JTextField();
        itsRequestHeadersPanel = new javax.swing.JPanel();
        itsRequestAddHeaderButton = new javax.swing.JButton();
        itsRequestRemoveHeaderButton = new javax.swing.JButton();
        itsRequestHeadersScrollPane = new javax.swing.JScrollPane();
        itsRequestHeadersTable = new javax.swing.JTable();
        itsRequestOkButton = new javax.swing.JButton();
        itsRequestCancelButton = new javax.swing.JButton();
        itsRequestDirectSendButton = new javax.swing.JButton();
        itsResponseEditPanel = new javax.swing.JPanel();
        itsResponseLeftPanel = new javax.swing.JPanel();
        itsResponseContentPane = new javax.swing.JScrollPane();
        itsResponseContentTextArea = new javax.swing.JTextArea();
        itsResponseCodePanel = new javax.swing.JPanel();
        responseCodeComboBoxLabel = new javax.swing.JLabel();
        itsResponseCodeComboBox = new javax.swing.JComboBox();
        itsResponseHeadersPanel = new javax.swing.JPanel();
        itsResponseAddHeaderButton = new javax.swing.JButton();
        itsResponseRemoveHeaderButton = new javax.swing.JButton();
        itsResponseHeadersScrollPane = new javax.swing.JScrollPane();
        itsResponseHeadersTable = new javax.swing.JTable();
        itsResponsePreviewPane = new javax.swing.JScrollPane();
        itsResponsePreviewTextArea = new javax.swing.JTextArea();
        itsResponseCancelButton = new javax.swing.JButton();
        itsResponseOkButton = new javax.swing.JButton();
        itsResponseDirectSendButton = new javax.swing.JButton();
        itsBottomPanel = new javax.swing.JPanel();
        itsResetButton = new javax.swing.JButton();
        itsApplyButton = new javax.swing.JButton();
        itsLocalConfigPanel = new javax.swing.JPanel();
        agentNameFieldLabel = new javax.swing.JLabel();
        logFileFieldLabel = new javax.swing.JLabel();
        itsAgentNameField = new javax.swing.JTextField();
        itsLogFileField = new javax.swing.JTextField();
        listeningPortFieldLabel = new javax.swing.JLabel();
        itsListeningPortField = new javax.swing.JTextField();
        transportFieldLabel = new javax.swing.JLabel();
        itsTransportField = new javax.swing.JComboBox();
        itsBrowseButton = new javax.swing.JButton();
        itsRemoteConfigPanel = new javax.swing.JPanel();
        hostFieldLabel = new javax.swing.JLabel();
        itsHostField = new javax.swing.JTextField();
        portFieldLabel = new javax.swing.JLabel();
        itsPortField = new javax.swing.JTextField();

        itsRemoveMessageMenuItem.setText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRemoveMessageMenuItem")); // NOI18N
        itsRemoveMessageMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRemoveMessageMenuItemActionPerformed(evt);
            }
        });
        itsHistoryPopup.add(itsRemoveMessageMenuItem);

        itsClearHistoryMenuItem.setText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsClearHistoryMenuItem")); // NOI18N
        itsClearHistoryMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsClearHistoryMenuItemActionPerformed(evt);
            }
        });
        itsHistoryPopup.add(itsClearHistoryMenuItem);

        itsFileDialog.setTitle("Warning");

        org.jdesktop.layout.GroupLayout itsFileDialogLayout = new org.jdesktop.layout.GroupLayout(itsFileDialog.getContentPane());
        itsFileDialog.getContentPane().setLayout(itsFileDialogLayout);
        itsFileDialogLayout.setHorizontalGroup(
            itsFileDialogLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 586, Short.MAX_VALUE)
            .add(itsFileChooser, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        itsFileDialogLayout.setVerticalGroup(
            itsFileDialogLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 326, Short.MAX_VALUE)
            .add(itsFileChooser, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );

        org.jdesktop.layout.GroupLayout itsInfoDialogLayout = new org.jdesktop.layout.GroupLayout(itsInfoDialog.getContentPane());
        itsInfoDialog.getContentPane().setLayout(itsInfoDialogLayout);
        itsInfoDialogLayout.setHorizontalGroup(
            itsInfoDialogLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 262, Short.MAX_VALUE)
            .add(itsInfoOptionPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        itsInfoDialogLayout.setVerticalGroup(
            itsInfoDialogLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 90, Short.MAX_VALUE)
            .add(itsInfoOptionPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );

        setAutoscrolls(true);
        setMaximumSize(new java.awt.Dimension(800, 600));
        setPreferredSize(new java.awt.Dimension(800, 600));

        jScrollPane3.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPane3.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsTopPanel.setMaximumSize(new java.awt.Dimension(800, 600));
        itsTopPanel.setPreferredSize(new java.awt.Dimension(800, 600));
        itsTopPanel.setLayout(new java.awt.CardLayout());

        itsMainPanel.setMaximumSize(new java.awt.Dimension(800, 600));

        itsCreationPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsCreationPanel"), javax.swing.border.TitledBorder.LEFT, javax.swing.border.TitledBorder.TOP)); // NOI18N
        itsCreationPanel.setPreferredSize(new java.awt.Dimension(200, 200));

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsCreationTextArea.setColumns(20);
        itsCreationTextArea.setRows(5);
        itsCreationTextArea.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsCreationTextArea")); // NOI18N
        jScrollPane1.setViewportView(itsCreationTextArea);

        org.openide.awt.Mnemonics.setLocalizedText(itsNewRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsNewRequestButton")); // NOI18N
        itsNewRequestButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsNewRequestButton")); // NOI18N
        itsNewRequestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsNewRequestButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsSendButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsSendButton")); // NOI18N
        itsSendButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsSendButton")); // NOI18N
        itsSendButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsSendButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsCreationPanelLayout = new org.jdesktop.layout.GroupLayout(itsCreationPanel);
        itsCreationPanel.setLayout(itsCreationPanelLayout);
        itsCreationPanelLayout.setHorizontalGroup(
            itsCreationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsCreationPanelLayout.createSequentialGroup()
                .add(35, 35, 35)
                .add(itsNewRequestButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsSendButton)
                .addContainerGap(62, Short.MAX_VALUE))
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE)
        );
        itsCreationPanelLayout.setVerticalGroup(
            itsCreationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, itsCreationPanelLayout.createSequentialGroup()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 429, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(itsCreationPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(itsNewRequestButton)
                    .add(itsSendButton))
                .addContainerGap())
        );

        itsHistoryPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsHistoryPanel"), javax.swing.border.TitledBorder.LEFT, javax.swing.border.TitledBorder.TOP)); // NOI18N
        itsHistoryPanel.setMaximumSize(new java.awt.Dimension(300, 300));

        org.openide.awt.Mnemonics.setLocalizedText(itsAckButton, "ACK");
        itsAckButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsAckButton")); // NOI18N
        itsAckButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsAckButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsByeButton, "BYE");
        itsByeButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsByeButton")); // NOI18N
        itsByeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsByeButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsCancelButton, "CANCEL");
        itsCancelButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsCancelButton")); // NOI18N
        itsCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsCancelButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestButton")); // NOI18N
        itsRequestButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestButton")); // NOI18N
        itsRequestButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(its200OKButton, "200 OK");
        its200OKButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_its200OKButton")); // NOI18N
        its200OKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                its200OKButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseButton")); // NOI18N
        itsResponseButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseButton")); // NOI18N
        itsResponseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsCopyMessageButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsCopyMessageButton")); // NOI18N
        itsCopyMessageButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsCopyMessageButton")); // NOI18N
        itsCopyMessageButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsCopyMessageButtonActionPerformed(evt);
            }
        });

        messageHistoryScollPane.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_messageHistoryScrollPane")); // NOI18N

        itsMessageHistory.setComponentPopupMenu(itsHistoryPopup);
        itsMessageHistory.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Message"
            }
        ));
        itsMessageHistory.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                itsMessageHistoryMouseClicked(evt);
            }
        });
        messageHistoryScollPane.setViewportView(itsMessageHistory);

        org.openide.awt.Mnemonics.setLocalizedText(itsHistoryLimitCheckBox, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsHistoryLimitCheckBox")); // NOI18N
        itsHistoryLimitCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsHistoryLimitCheckBox")); // NOI18N
        itsHistoryLimitCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        itsHistoryLimitCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsHistoryLimitCheckBoxActionPerformed(evt);
            }
        });

        itsHistoryLimitField.setText("20");
        itsHistoryLimitField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsHistoryLimitField")); // NOI18N
        itsHistoryLimitField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                itsHistoryLimitFieldFocusLost(evt);
            }
        });

        jLabel7.setText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_jLabel7")); // NOI18N

        jScrollPane2.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);

        itsSelectedMessagePane.setBackground(new java.awt.Color(226, 242, 244));
        itsSelectedMessagePane.setBorder(null);
        itsSelectedMessagePane.setEditable(false);
        itsSelectedMessagePane.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsSelectedMessagePane")); // NOI18N
        jScrollPane2.setViewportView(itsSelectedMessagePane);

        org.jdesktop.layout.GroupLayout itsHistoryPanelLayout = new org.jdesktop.layout.GroupLayout(itsHistoryPanel);
        itsHistoryPanel.setLayout(itsHistoryPanelLayout);
        itsHistoryPanelLayout.setHorizontalGroup(
            itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, itsHistoryPanelLayout.createSequentialGroup()
                .addContainerGap(27, Short.MAX_VALUE)
                .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsHistoryPanelLayout.createSequentialGroup()
                        .add(itsHistoryLimitCheckBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsHistoryLimitField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(4, 4, 4)
                        .add(jLabel7))
                    .add(itsHistoryPanelLayout.createSequentialGroup()
                        .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(messageHistoryScollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 269, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 269, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(itsResponseButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(its200OKButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(itsRequestButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(itsCancelButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(itsByeButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(itsAckButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 95, Short.MAX_VALUE)
                            .add(itsCopyMessageButton)))))
        );
        itsHistoryPanelLayout.setVerticalGroup(
            itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsHistoryPanelLayout.createSequentialGroup()
                .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsHistoryPanelLayout.createSequentialGroup()
                        .add(itsAckButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsByeButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsCancelButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(its200OKButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponseButton))
                    .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 190, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsCopyMessageButton)
                    .add(messageHistoryScollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 251, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsHistoryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(itsHistoryLimitCheckBox)
                    .add(itsHistoryLimitField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel7))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout itsMainPanelLayout = new org.jdesktop.layout.GroupLayout(itsMainPanel);
        itsMainPanel.setLayout(itsMainPanelLayout);
        itsMainPanelLayout.setHorizontalGroup(
            itsMainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsMainPanelLayout.createSequentialGroup()
                .add(4, 4, 4)
                .add(itsCreationPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 328, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsHistoryPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        itsMainPanelLayout.setVerticalGroup(
            itsMainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, itsMainPanelLayout.createSequentialGroup()
                .add(itsMainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, itsHistoryPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(itsCreationPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 510, Short.MAX_VALUE))
                .addContainerGap())
        );

        itsTopPanel.add(itsMainPanel, "card1");

        itsRequestPreviewPane.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestPreviewPane"))); // NOI18N
        itsRequestPreviewPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        itsRequestPreviewPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsRequestPreviewTextArea.setBackground(new java.awt.Color(221, 236, 252));
        itsRequestPreviewTextArea.setColumns(20);
        itsRequestPreviewTextArea.setEditable(false);
        itsRequestPreviewTextArea.setRows(5);
        itsRequestPreviewTextArea.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestPreviewTextArea")); // NOI18N
        itsRequestPreviewTextArea.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        itsRequestPreviewTextArea.setEnabled(false);
        itsRequestPreviewTextArea.setMaximumSize(new java.awt.Dimension(200, 200));
        itsRequestPreviewPane.setViewportView(itsRequestPreviewTextArea);

        itsRequestContentPane.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestContentPane"))); // NOI18N
        itsRequestContentPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        itsRequestContentPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsRequestContentTextArea.setColumns(20);
        itsRequestContentTextArea.setRows(5);
        itsRequestContentTextArea.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestContentTextArea")); // NOI18N
        itsRequestContentTextArea.setAutoscrolls(false);
        itsRequestContentTextArea.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        itsRequestContentTextArea.setMinimumSize(new java.awt.Dimension(0, 0));
        itsRequestContentTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsRequestContentTextAreaKeyReleased(evt);
            }
        });
        itsRequestContentPane.setViewportView(itsRequestContentTextArea);

        itsRequestPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestPanel"))); // NOI18N

        requestMethodComboBoxLabel.setLabelFor(itsRequestMethodComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(requestMethodComboBoxLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_requestMethodComboBoxLabel")); // NOI18N

        itsRequestMethodComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "ACK", "BYE", "CANCEL", "INFO", "INVITE", "MESSAGE", "NOTIFY", "OPTIONS", "PRACK", "PUBLISH", "REGISTER", "SUBSCRIBE" }));
        itsRequestMethodComboBox.setSelectedIndex(10);
        itsRequestMethodComboBox.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestMethodComboBox")); // NOI18N
        itsRequestMethodComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestMethodComboBoxActionPerformed(evt);
            }
        });

        requestUriFieldLabel.setLabelFor(itsRequestUriTextField);
        org.openide.awt.Mnemonics.setLocalizedText(requestUriFieldLabel, "URI:");

        itsRequestUriTextField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestUriTextField")); // NOI18N
        itsRequestUriTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsRequestUriTextFieldKeyReleased(evt);
            }
        });

        itsRequestFromPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("From"));

        org.openide.awt.Mnemonics.setLocalizedText(requestFromnameFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_requestFromNameFieldLabel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(requestFromUriFieldLabel, "URI:");

        itsRequestFromNameTextField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestFromNameTextField")); // NOI18N
        itsRequestFromNameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsFromKeyReleased(evt);
            }
        });

        itsRequestFromUriTextField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestFromUriTextField")); // NOI18N
        itsRequestFromUriTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsFromKeyReleased(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsRequestFromPanelLayout = new org.jdesktop.layout.GroupLayout(itsRequestFromPanel);
        itsRequestFromPanel.setLayout(itsRequestFromPanelLayout);
        itsRequestFromPanelLayout.setHorizontalGroup(
            itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestFromPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(requestFromnameFieldLabel)
                    .add(requestFromUriFieldLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsRequestFromUriTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)
                    .add(itsRequestFromNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)))
        );
        itsRequestFromPanelLayout.setVerticalGroup(
            itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestFromPanelLayout.createSequentialGroup()
                .add(itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(requestFromnameFieldLabel)
                    .add(itsRequestFromNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestFromPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(requestFromUriFieldLabel)
                    .add(itsRequestFromUriTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(12, Short.MAX_VALUE))
        );

        itsRequestToPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("To"));

        org.openide.awt.Mnemonics.setLocalizedText(requestToNameFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_requestToNameFieldlabel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel11, "URI:");

        itsRequestToNameTextField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestToNameTextField")); // NOI18N
        itsRequestToNameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsToKeyReleased(evt);
            }
        });

        itsRequestToUriTextField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestToUriTextField")); // NOI18N
        itsRequestToUriTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsToKeyReleased(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsRequestToPanelLayout = new org.jdesktop.layout.GroupLayout(itsRequestToPanel);
        itsRequestToPanel.setLayout(itsRequestToPanelLayout);
        itsRequestToPanelLayout.setHorizontalGroup(
            itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestToPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(requestToNameFieldLabel)
                    .add(jLabel11))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsRequestToUriTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)
                    .add(itsRequestToNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)))
        );
        itsRequestToPanelLayout.setVerticalGroup(
            itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestToPanelLayout.createSequentialGroup()
                .add(itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(requestToNameFieldLabel)
                    .add(itsRequestToNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestToPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel11)
                    .add(itsRequestToUriTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout itsRequestPanelLayout = new org.jdesktop.layout.GroupLayout(itsRequestPanel);
        itsRequestPanel.setLayout(itsRequestPanelLayout);
        itsRequestPanelLayout.setHorizontalGroup(
            itsRequestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestPanelLayout.createSequentialGroup()
                .add(requestMethodComboBoxLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestMethodComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requestUriFieldLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestUriTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 321, Short.MAX_VALUE))
            .add(itsRequestPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsRequestToPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestFromPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        itsRequestPanelLayout.linkSize(new java.awt.Component[] {itsRequestFromPanel, itsRequestToPanel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        itsRequestPanelLayout.setVerticalGroup(
            itsRequestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestPanelLayout.createSequentialGroup()
                .add(itsRequestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(requestMethodComboBoxLabel)
                    .add(itsRequestMethodComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(requestUriFieldLabel)
                    .add(itsRequestUriTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(itsRequestFromPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(itsRequestToPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        itsRequestHeadersPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestHeadersPanel"))); // NOI18N
        itsRequestHeadersPanel.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestHeadersPanel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestAddHeaderButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestAddHeaderButton")); // NOI18N
        itsRequestAddHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestAddHeaderButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestRemoveHeaderButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestRemoveHeaderButton")); // NOI18N
        itsRequestRemoveHeaderButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestRemoveHeaderButton")); // NOI18N
        itsRequestRemoveHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestRemoveHeaderButtonActionPerformed(evt);
            }
        });

        itsRequestHeadersScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        itsRequestHeadersScrollPane.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestheadersScrollPane")); // NOI18N
        itsRequestHeadersScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsRequestHeadersTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        itsRequestHeadersTable.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestHeadersTable")); // NOI18N
        itsRequestHeadersTable.setColumnSelectionAllowed(true);
        TableColumn nameColumn2 = itsRequestHeadersTable.getColumn("Name");
        nameColumn2.setCellEditor(new DefaultCellEditor(new HeaderComboBox()));

        itsRequestHeadersScrollPane.setViewportView(itsRequestHeadersTable);

        org.jdesktop.layout.GroupLayout itsRequestHeadersPanelLayout = new org.jdesktop.layout.GroupLayout(itsRequestHeadersPanel);
        itsRequestHeadersPanel.setLayout(itsRequestHeadersPanelLayout);
        itsRequestHeadersPanelLayout.setHorizontalGroup(
            itsRequestHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, itsRequestHeadersPanelLayout.createSequentialGroup()
                .add(itsRequestHeadersScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 420, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(itsRequestAddHeaderButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(itsRequestRemoveHeaderButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        itsRequestHeadersPanelLayout.setVerticalGroup(
            itsRequestHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestHeadersPanelLayout.createSequentialGroup()
                .add(itsRequestHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsRequestHeadersPanelLayout.createSequentialGroup()
                        .add(itsRequestAddHeaderButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestRemoveHeaderButton))
                    .add(itsRequestHeadersScrollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 97, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestOkButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestOkButton")); // NOI18N
        itsRequestOkButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestOkButton")); // NOI18N
        itsRequestOkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestOkButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestCancelButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestCancelButton")); // NOI18N
        itsRequestCancelButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestCancelButton")); // NOI18N
        itsRequestCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestCancelButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsRequestDirectSendButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRequestDirectSendButton")); // NOI18N
        itsRequestDirectSendButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsRequestDirectSendButton")); // NOI18N
        itsRequestDirectSendButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsRequestDirectSendButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsRequestEditPanelLayout = new org.jdesktop.layout.GroupLayout(itsRequestEditPanel);
        itsRequestEditPanel.setLayout(itsRequestEditPanelLayout);
        itsRequestEditPanelLayout.setHorizontalGroup(
            itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestEditPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsRequestEditPanelLayout.createSequentialGroup()
                        .add(itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(itsRequestContentPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 509, Short.MAX_VALUE)
                            .add(itsRequestPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(itsRequestHeadersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestPreviewPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 280, Short.MAX_VALUE)
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, itsRequestEditPanelLayout.createSequentialGroup()
                        .add(itsRequestDirectSendButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestOkButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 59, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestCancelButton)
                        .add(29, 29, 29))))
        );
        itsRequestEditPanelLayout.setVerticalGroup(
            itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRequestEditPanelLayout.createSequentialGroup()
                .add(itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(itsRequestEditPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(itsRequestPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsRequestHeadersPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(itsRequestContentPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 148, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, itsRequestPreviewPane))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsRequestEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(itsRequestDirectSendButton)
                    .add(itsRequestOkButton)
                    .add(itsRequestCancelButton))
                .addContainerGap())
        );

        itsTopPanel.add(itsRequestEditPanel, "card2");

        itsResponseContentPane.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseContentPane"))); // NOI18N
        itsResponseContentPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        itsResponseContentPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsResponseContentTextArea.setColumns(20);
        itsResponseContentTextArea.setRows(5);
        itsResponseContentTextArea.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseContentTextArea")); // NOI18N
        itsResponseContentTextArea.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        itsResponseContentTextArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                itsResponseContentTextAreaKeyReleased(evt);
            }
        });
        itsResponseContentPane.setViewportView(itsResponseContentTextArea);

        itsResponseCodePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseCodePanel"))); // NOI18N

        responseCodeComboBoxLabel.setLabelFor(itsResponseCodeComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(responseCodeComboBoxLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_responseCodeComboBoxLabel")); // NOI18N

        itsResponseCodeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "100 Trying", "180 Ringing", "181 Call Being Forwarded", "182 Call Queued", "183 Session Progress", "200 OK", "202 Accepted", "300 Multiple Choices", "301 Moved Permanently", "302 Moved Temporarily", "305 Use Proxy", "380 Alternative Service", "400 Bad Request", "401 Unauthorized", "402 Payment Required", "403 Forbidden", "404 Not Found", "405 Method Not Allowed", "406 Not Acceptable", "407 Proxy Authentication Required", "408 Request Timeout", "410 Gone", "413 Request Entity Too Large", "414 Request URI Too Long", "415 Unsupported Media Type", "416 Unsupported URI Scheme", "420 Bad Extension", "421 Extension Required", "423 Interval Too Brief", "480 Temporarly Unavailable", "481 Call Leg Done", "482 Loop Detected", "483 Too Many Hops", "484 Address Incomplete", "485 Ambiguous", "486 Busy Here", "487 Request Terminated", "488 Not Acceptable Here", "491 Request Pending", "493 Undecipherable", "500 Server Internal Error", "501 Not Implemented", "502 Bad Gateway", "503 Service Unavailable", "504 Server Timeout", "505 Version Not Supported", "513 Message Too Large", "600 Busy Everywhere", "603 Decline", "604 Does Not Exist Anywhere", "606 Not Acceptable Anywhere" }));
        itsResponseCodeComboBox.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseCodeComboBox")); // NOI18N
        itsResponseCodeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseCodeComboBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsResponseCodePanelLayout = new org.jdesktop.layout.GroupLayout(itsResponseCodePanel);
        itsResponseCodePanel.setLayout(itsResponseCodePanelLayout);
        itsResponseCodePanelLayout.setHorizontalGroup(
            itsResponseCodePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseCodePanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(responseCodeComboBoxLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsResponseCodeComboBox, 0, 202, Short.MAX_VALUE)
                .addContainerGap())
        );
        itsResponseCodePanelLayout.setVerticalGroup(
            itsResponseCodePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseCodePanelLayout.createSequentialGroup()
                .add(itsResponseCodePanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(responseCodeComboBoxLabel)
                    .add(itsResponseCodeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        itsResponseHeadersPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseHeadersPanel"))); // NOI18N
        itsResponseHeadersPanel.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseHeadersPanel")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseAddHeaderButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseAddHeaderButton")); // NOI18N
        itsResponseAddHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseAddHeaderButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseRemoveHeaderButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseRemoveHeaderButton")); // NOI18N
        itsResponseRemoveHeaderButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseRemoveHeaderButtonActionPerformed(evt);
            }
        });

        itsResponseHeadersScrollPane.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseHeadersScrollPane")); // NOI18N

        itsResponseHeadersTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        itsResponseHeadersTable.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseHeadersTable")); // NOI18N
        TableColumn nameColumn = itsResponseHeadersTable.getColumn("Name");
        nameColumn.setCellEditor(new DefaultCellEditor(new HeaderComboBox()));
        itsResponseHeadersScrollPane.setViewportView(itsResponseHeadersTable);

        org.jdesktop.layout.GroupLayout itsResponseHeadersPanelLayout = new org.jdesktop.layout.GroupLayout(itsResponseHeadersPanel);
        itsResponseHeadersPanel.setLayout(itsResponseHeadersPanelLayout);
        itsResponseHeadersPanelLayout.setHorizontalGroup(
            itsResponseHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, itsResponseHeadersPanelLayout.createSequentialGroup()
                .add(itsResponseHeadersScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 270, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsResponseHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, itsResponseAddHeaderButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, itsResponseRemoveHeaderButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        itsResponseHeadersPanelLayout.setVerticalGroup(
            itsResponseHeadersPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseHeadersPanelLayout.createSequentialGroup()
                .add(itsResponseAddHeaderButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsResponseRemoveHeaderButton)
                .addContainerGap(81, Short.MAX_VALUE))
            .add(itsResponseHeadersScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 139, Short.MAX_VALUE)
        );

        itsResponsePreviewPane.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponsePreviewPane"))); // NOI18N
        itsResponsePreviewPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        itsResponsePreviewPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        itsResponsePreviewTextArea.setBackground(new java.awt.Color(204, 204, 204));
        itsResponsePreviewTextArea.setColumns(20);
        itsResponsePreviewTextArea.setRows(5);
        itsResponsePreviewTextArea.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponsePreviewTextArea")); // NOI18N
        itsResponsePreviewTextArea.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        itsResponsePreviewPane.setViewportView(itsResponsePreviewTextArea);

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseCancelButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseCancelButton")); // NOI18N
        itsResponseCancelButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseCancelButton")); // NOI18N
        itsResponseCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseCancelButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseOkButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseOkButton")); // NOI18N
        itsResponseOkButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseOkButton")); // NOI18N
        itsResponseOkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseOkButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsResponseDirectSendButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResponseDirectSendButton")); // NOI18N
        itsResponseDirectSendButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResponseDirectSendButton")); // NOI18N
        itsResponseDirectSendButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResponseDirectSendButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsResponseLeftPanelLayout = new org.jdesktop.layout.GroupLayout(itsResponseLeftPanel);
        itsResponseLeftPanel.setLayout(itsResponseLeftPanelLayout);
        itsResponseLeftPanelLayout.setHorizontalGroup(
            itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseLeftPanelLayout.createSequentialGroup()
                .add(itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsResponseLeftPanelLayout.createSequentialGroup()
                        .add(itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(itsResponseContentPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE)
                            .add(itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(itsResponseCodePanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(itsResponseHeadersPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponsePreviewPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 369, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, itsResponseLeftPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(itsResponseDirectSendButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponseOkButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponseCancelButton)))
                .addContainerGap(59, Short.MAX_VALUE))
        );

        itsResponseLeftPanelLayout.linkSize(new java.awt.Component[] {itsResponseCodePanel, itsResponseContentPane, itsResponseHeadersPanel, itsResponsePreviewPane}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        itsResponseLeftPanelLayout.setVerticalGroup(
            itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseLeftPanelLayout.createSequentialGroup()
                .add(itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsResponseLeftPanelLayout.createSequentialGroup()
                        .add(itsResponseCodePanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponseHeadersPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsResponseContentPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 240, Short.MAX_VALUE))
                    .add(itsResponseLeftPanelLayout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(itsResponsePreviewPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 466, Short.MAX_VALUE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsResponseLeftPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(itsResponseCancelButton)
                    .add(itsResponseOkButton)
                    .add(itsResponseDirectSendButton)))
        );

        org.jdesktop.layout.GroupLayout itsResponseEditPanelLayout = new org.jdesktop.layout.GroupLayout(itsResponseEditPanel);
        itsResponseEditPanel.setLayout(itsResponseEditPanelLayout);
        itsResponseEditPanelLayout.setHorizontalGroup(
            itsResponseEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseEditPanelLayout.createSequentialGroup()
                .add(itsResponseLeftPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        itsResponseEditPanelLayout.setVerticalGroup(
            itsResponseEditPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsResponseEditPanelLayout.createSequentialGroup()
                .add(itsResponseLeftPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        itsTopPanel.add(itsResponseEditPanel, "card3");

        org.openide.awt.Mnemonics.setLocalizedText(itsResetButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsResetButton")); // NOI18N
        itsResetButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsResetButton")); // NOI18N
        itsResetButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        itsResetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsResetButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(itsApplyButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsApplyButton")); // NOI18N
        itsApplyButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsApplyButton")); // NOI18N
        itsApplyButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        itsApplyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsApplyButtonActionPerformed(evt);
            }
        });

        itsLocalConfigPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Local Configuration"));

        agentNameFieldLabel.setLabelFor(itsAgentNameField);
        org.openide.awt.Mnemonics.setLocalizedText(agentNameFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_agentNameFieldLabel")); // NOI18N

        logFileFieldLabel.setLabelFor(itsLogFileField);
        org.openide.awt.Mnemonics.setLocalizedText(logFileFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_logFileFieldLabel")); // NOI18N

        itsAgentNameField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsAgentNameField")); // NOI18N

        itsLogFileField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsLogFieldField")); // NOI18N

        listeningPortFieldLabel.setLabelFor(itsListeningPortField);
        org.openide.awt.Mnemonics.setLocalizedText(listeningPortFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_listeningPortFieldLabel")); // NOI18N

        itsListeningPortField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsListeningPortField")); // NOI18N

        transportFieldLabel.setLabelFor(itsTransportField);
        org.openide.awt.Mnemonics.setLocalizedText(transportFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_transportLabel")); // NOI18N

        itsTransportField.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "UDP", "TCP" }));
        itsTransportField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsTransportField")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(itsBrowseButton, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsBrowseButton")); // NOI18N
        itsBrowseButton.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsBrowseButton")); // NOI18N
        itsBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itsBrowseButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout itsLocalConfigPanelLayout = new org.jdesktop.layout.GroupLayout(itsLocalConfigPanel);
        itsLocalConfigPanel.setLayout(itsLocalConfigPanelLayout);
        itsLocalConfigPanelLayout.setHorizontalGroup(
            itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsLocalConfigPanelLayout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(agentNameFieldLabel)
                    .add(logFileFieldLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(itsLocalConfigPanelLayout.createSequentialGroup()
                        .add(itsAgentNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(7, 7, 7)
                        .add(listeningPortFieldLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(itsListeningPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 34, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(itsLogFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 188, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(itsLocalConfigPanelLayout.createSequentialGroup()
                        .add(transportFieldLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(itsTransportField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(itsBrowseButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .add(124, 124, 124))
        );

        itsLocalConfigPanelLayout.linkSize(new java.awt.Component[] {agentNameFieldLabel, logFileFieldLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        itsLocalConfigPanelLayout.setVerticalGroup(
            itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsLocalConfigPanelLayout.createSequentialGroup()
                .add(itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(agentNameFieldLabel)
                    .add(itsAgentNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(listeningPortFieldLabel)
                    .add(itsListeningPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(transportFieldLabel)
                    .add(itsTransportField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsLocalConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(logFileFieldLabel)
                    .add(itsLogFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(itsBrowseButton)))
        );

        itsRemoteConfigPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_itsRemoteConfigPanel"))); // NOI18N

        hostFieldLabel.setLabelFor(itsHostField);
        org.openide.awt.Mnemonics.setLocalizedText(hostFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_hostFieldLabel")); // NOI18N

        itsHostField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsHostField")); // NOI18N

        portFieldLabel.setLabelFor(itsPortField);
        org.openide.awt.Mnemonics.setLocalizedText(portFieldLabel, org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "LBL_portFieldLabel")); // NOI18N

        itsPortField.setToolTipText(org.openide.util.NbBundle.getMessage(AgentMainJPanel.class, "TIP_itsPortField")); // NOI18N

        org.jdesktop.layout.GroupLayout itsRemoteConfigPanelLayout = new org.jdesktop.layout.GroupLayout(itsRemoteConfigPanel);
        itsRemoteConfigPanel.setLayout(itsRemoteConfigPanelLayout);
        itsRemoteConfigPanelLayout.setHorizontalGroup(
            itsRemoteConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRemoteConfigPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(hostFieldLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsHostField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 185, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(portFieldLabel)
                .add(7, 7, 7)
                .add(itsPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 38, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        itsRemoteConfigPanelLayout.linkSize(new java.awt.Component[] {hostFieldLabel, portFieldLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        itsRemoteConfigPanelLayout.setVerticalGroup(
            itsRemoteConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsRemoteConfigPanelLayout.createSequentialGroup()
                .add(itsRemoteConfigPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(hostFieldLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(itsPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(itsHostField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(portFieldLabel))
                .addContainerGap(42, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout itsBottomPanelLayout = new org.jdesktop.layout.GroupLayout(itsBottomPanel);
        itsBottomPanel.setLayout(itsBottomPanelLayout);
        itsBottomPanelLayout.setHorizontalGroup(
            itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsBottomPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(itsLocalConfigPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 408, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(itsResetButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(itsApplyButton)
                    .add(itsRemoteConfigPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        itsBottomPanelLayout.setVerticalGroup(
            itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(itsBottomPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(itsLocalConfigPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 90, Short.MAX_VALUE)
                    .add(itsRemoteConfigPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(itsBottomPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(itsApplyButton)
                    .add(itsResetButton))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 843, Short.MAX_VALUE)
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel1Layout.createSequentialGroup()
                    .addContainerGap()
                    .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(itsTopPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 819, Short.MAX_VALUE)
                        .add(itsBottomPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .addContainerGap()))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 698, Short.MAX_VALUE)
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                    .addContainerGap()
                    .add(itsTopPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 522, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(itsBottomPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap()))
        );

        jScrollPane3.setViewportView(jPanel1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 846, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 520, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

private void itsResponseDirectSendButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseDirectSendButtonActionPerformed
    this.itsResponseOkButtonActionPerformed(evt);
    this.itsSendButtonActionPerformed(evt);
}//GEN-LAST:event_itsResponseDirectSendButtonActionPerformed

private void itsRequestDirectSendButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestDirectSendButtonActionPerformed
    this.itsRequestOkButtonActionPerformed(evt);
    this.itsSendButtonActionPerformed(evt);
}//GEN-LAST:event_itsRequestDirectSendButtonActionPerformed

    // ------------------------------------------------------------------------
    //  Swing event handlers
    // ------------------------------------------------------------------------
    private void itsResponseOkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseOkButtonActionPerformed
       // Done creating response.
        String text = itsResponsePreviewTextArea.getText();
        itsCreationTextArea.setText(text);

        // itsResponseBean no longer needed, new one will be created once form
        // is reopened.
        itsResponseHeaderTableListener.setBean(null);
        itsResponseBean = null;

        // return to first card
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card1");
    }//GEN-LAST:event_itsResponseOkButtonActionPerformed

    private void itsResponseRemoveHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseRemoveHeaderButtonActionPerformed
        this.doRemoveRowFromHeaderTable(itsResponseHeadersTable, itsResponseHeaderTableListener);
    }//GEN-LAST:event_itsResponseRemoveHeaderButtonActionPerformed

    private void itsResponseContentTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_itsResponseContentTextAreaKeyReleased
        itsResponseBean.setContent(itsResponseContentTextArea.getText());
        updatePreviewPanel(itsResponseBean);

        // refill the header table, content-length has changed
        initHeaderTable(itsResponseHeadersTable, itsResponseBean);
    }//GEN-LAST:event_itsResponseContentTextAreaKeyReleased
        private void itsResponseAddHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseAddHeaderButtonActionPerformed
        this.doAddRowToHeaderTable(itsResponseHeadersTable, itsResponseHeaderTableListener);
    }//GEN-LAST:event_itsResponseAddHeaderButtonActionPerformed

    private void itsResponseCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseCancelButtonActionPerformed
        // back to main panel (card1)
        // back to main panel (card1)
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card1");
    }//GEN-LAST:event_itsResponseCancelButtonActionPerformed


    private void itsMessageHistoryMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_itsMessageHistoryMouseClicked
        // Show selected message
        // Show selected message
        int i = itsMessageHistory.getSelectedRow();        
        if (i < 0) {
            itsSelectedMessagePane.setText("");
            return;
        }
        Object msg = ((DefaultTableModel) itsMessageHistory.getModel()).getValueAt(i, 0);
        itsSelectedMessagePane.setText(msg.toString());
        if (!msg.toString().startsWith("SIP")) {
            itsAckButton.setEnabled(false);
            itsByeButton.setEnabled(false);
            itsRequestButton.setEnabled(false);
            itsResponseButton.setEnabled(true);
            itsCancelButton.setEnabled(true);
        } else {
            itsAckButton.setEnabled(true);
            itsByeButton.setEnabled(true);
            itsRequestButton.setEnabled(true);
            itsResponseButton.setEnabled(false);
            itsCancelButton.setEnabled(false);
        }
    }//GEN-LAST:event_itsMessageHistoryMouseClicked

    private void itsCopyMessageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsCopyMessageButtonActionPerformed
        // Just copy text from right to left area.
        itsCreationTextArea.setText(itsSelectedMessagePane.getText());
    }//GEN-LAST:event_itsCopyMessageButtonActionPerformed

    private void itsResponseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseButtonActionPerformed

        // try to create a response based on the text in the 'Message History',
        // assuming this is a request that was received earlier. If creating the
        // response fails, a dummy response is created.
        itsResponseBean = itsAgent.prepareResponseFromRequest(
            itsSelectedMessagePane.getText());
        openResponseEditor();
    }
    
    private void openResponseEditor() {

        // Fill the ResponseEdit window with stuff retrieved from the bean.
        itsResponseCodeComboBox.setSelectedItem(itsResponseBean.getResponseCode());
        itsResponseContentTextArea.setText(itsResponseBean.getContent());
        itsResponsePreviewTextArea.setText(itsResponseBean.toString());

        initHeaderTable(itsResponseHeadersTable, itsResponseBean);

        if (itsResponseHeaderTableListener == null) {
            // first time this button was pressed, add a listener
            itsResponseHeaderTableListener = 
                new HeaderTableListener(this, itsResponseBean);
        } else {
            itsResponseHeaderTableListener.setBean(itsResponseBean);
        }

       // Add a listener to the headers table to make sure any changes are
        // propagated to the underlying RequestBean.
        TableModel model = itsResponseHeadersTable.getModel();
        model.addTableModelListener(itsResponseHeaderTableListener);

        // show response creation panel (card3)
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card3");
    }//GEN-LAST:event_itsResponseButtonActionPerformed

    private void its200OKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_its200OKButtonActionPerformed
        // prepare a response based on the text in the selected message pane
        String txt = itsSelectedMessagePane.getText().trim();
        if (txt.length() > 0) {
            ResponseBean response = itsAgent.prepareResponseFromRequest(txt);
            itsCreationTextArea.setText(response.toString());
        } else {
            // put up the error dialog
            DialogDisplayer.getDefault().notify(new NotifyDescriptor(
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY"),
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY_TITLE"),
                    NotifyDescriptor.DEFAULT_OPTION, NotifyDescriptor.ERROR_MESSAGE,
                    null, null));
        }
    }//GEN-LAST:event_its200OKButtonActionPerformed

    private void itsRequestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestButtonActionPerformed
        String responseText = itsSelectedMessagePane.getText().trim();
        if (responseText != null && !("".equals(responseText))) {
            ResponseBean resp = itsAgent.prepareResponse(responseText);
            RequestBean req = new RequestBean(resp);
            req.setMethod(Constants.BYE);
            String txt = req.toString();
            itsCreationTextArea.setText(txt);
            itsRequestBean = itsAgent.prepareRequest(txt);
            this.openRequestEditor(evt,txt);
        } else {
            // put up the error dialog
            DialogDisplayer.getDefault().notify(new NotifyDescriptor(
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY"),
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY_TITLE"),
                    NotifyDescriptor.DEFAULT_OPTION, NotifyDescriptor.ERROR_MESSAGE,
                    null, null));
        }
    }//GEN-LAST:event_itsRequestButtonActionPerformed

    private void itsCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsCancelButtonActionPerformed
        // read text from itsSelectedMessagePane, interpret as request and
        // create CANCEL request based on that.
        String requestText = itsSelectedMessagePane.getText();
        if (requestText != null && !("".equals(requestText))) {
            RequestBean req = itsAgent.prepareRequest(requestText);
            req.setMethod(Constants.CANCEL);
            itsCreationTextArea.setText(req.toString());
        } else {
            // put up the error dialog
            DialogDisplayer.getDefault().notify(new NotifyDescriptor(
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY"),
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY_TITLE"),
                    NotifyDescriptor.DEFAULT_OPTION, NotifyDescriptor.ERROR_MESSAGE,
                    null, null));
        }  
    }//GEN-LAST:event_itsCancelButtonActionPerformed

    private void itsByeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsByeButtonActionPerformed
        // read text from itsSelectedMessagePane, interpret as response and
        // create BYE request based on that.
        String responseText = itsSelectedMessagePane.getText();
        if (responseText != null && !("".equals(responseText))) {
            ResponseBean resp = itsAgent.prepareResponse(responseText);
            RequestBean req = new RequestBean(resp);
            req.setMethod(Constants.BYE);
            itsCreationTextArea.setText(req.toString());
        } else {
            // put up the error dialog
            DialogDisplayer.getDefault().notify(new NotifyDescriptor(
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY"),
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY_TITLE"),
                    NotifyDescriptor.DEFAULT_OPTION, NotifyDescriptor.ERROR_MESSAGE,
                    null, null));
        }
    }//GEN-LAST:event_itsByeButtonActionPerformed

    private void itsAckButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsAckButtonActionPerformed
        // read text from itsSelectedMessagePane, interpret as response and
        // create ACK request based on that.
        String responseText = itsSelectedMessagePane.getText().trim();
        if (responseText != null && !("".equals(responseText))) {
            ResponseBean resp = itsAgent.prepareResponse(responseText);
            RequestBean req = new RequestBean(resp);
            req.setMethod(Constants.ACK);
            
           itsCreationTextArea.setText(req.toString());
        } else {
            // put up the error dialog
            DialogDisplayer.getDefault().notify(new NotifyDescriptor(
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY"),
                    NbBundle.getMessage(AgentMainJPanel.class,"ERR_PICK_HISTORY_ENTRY_TITLE"),
                    NotifyDescriptor.DEFAULT_OPTION, NotifyDescriptor.ERROR_MESSAGE,
                    null, null));
        }
    }//GEN-LAST:event_itsAckButtonActionPerformed

    private void itsHistoryLimitFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_itsHistoryLimitFieldFocusLost
        doLimitHistory();
    }//GEN-LAST:event_itsHistoryLimitFieldFocusLost

    private void itsHistoryLimitCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsHistoryLimitCheckBoxActionPerformed
        doLimitHistory();
    }//GEN-LAST:event_itsHistoryLimitCheckBoxActionPerformed

    private void doLimitHistory() {
        // verify that the checkbox is ticked
        if (itsHistoryLimitCheckBox.isSelected()) {
            String limitStr = itsHistoryLimitField.getText();
            int limit = 0;
            try {
                limit = Integer.parseInt(limitStr);
            } catch (NumberFormatException e) {
                limit = 0;
                itsHistoryLimitField.setText("0");
            }
            int currentRowCount = ((DefaultTableModel) itsMessageHistory.getModel()).getRowCount();
            // check if currentRowCount is larger than the new limit
            if (currentRowCount > limit) {
                // it is, so remove all rows above the limit
                ((DefaultTableModel) itsMessageHistory.getModel()).setRowCount(limit);
            } // else:  room for more
            itsHistoryLimit = limit;
            theirLogger.fine("History limit set to " + limit + " messages");
        } else {
            itsHistoryLimit = HISTORY_UNLIMITED;
            theirLogger.fine("History limit not set");
        }
    }

    private void itsBrowseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsBrowseButtonActionPerformed
        theirLogger.fine("Browse for log file...");
        int returnVal = itsFileChooser.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = itsFileChooser.getSelectedFile();
            itsLogFileField.setText(file.toString());
            theirLogger.fine("Logfile set to: " + file);
            itsConstants.setProperty(Constants.TRAFFIC_LOGGING_ENABLED, "true");
            itsAgent.initLogFile(file.toString());
        }
    }//GEN-LAST:event_itsBrowseButtonActionPerformed

    private void itsClearHistoryMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsClearHistoryMenuItemActionPerformed
        //itsHistory.clear();
        ((DefaultTableModel) itsMessageHistory.getModel()).setRowCount(0);
    }//GEN-LAST:event_itsClearHistoryMenuItemActionPerformed

    private void itsRemoveMessageMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRemoveMessageMenuItemActionPerformed
        // Remove selected message
        int i = itsMessageHistory.getSelectedRow();
        if (i != -1) {
            ((DefaultTableModel) itsMessageHistory.getModel()).removeRow(i);
        } else {
            // no row selected
        }
    }//GEN-LAST:event_itsRemoveMessageMenuItemActionPerformed

    private void itsRequestRemoveHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestRemoveHeaderButtonActionPerformed
        this.doRemoveRowFromHeaderTable(itsRequestHeadersTable, itsRequestHeaderTableListener);
    }//GEN-LAST:event_itsRequestRemoveHeaderButtonActionPerformed

    private void itsRequestAddHeaderButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestAddHeaderButtonActionPerformed
        this.doAddRowToHeaderTable(itsRequestHeadersTable, itsRequestHeaderTableListener);
    }//GEN-LAST:event_itsRequestAddHeaderButtonActionPerformed

    private void doAddRowToHeaderTable(final JTable aTable, HeaderTableListener aListener) {

        // add a row to the headers table

        // add a row to the headers table
        DefaultTableModel model = (DefaultTableModel) (aTable.getModel());
        model.addRow(new String[]{"", ""});

        aListener.repopulate(model);

        // scroll to end
        Runnable scroll = new Runnable() {

            public void run() {
                aTable.scrollRectToVisible(aTable.getCellRect(aTable.getRowCount(), 0, true));
            }
        };
        SwingUtilities.invokeLater(scroll);
    }

    private void doRemoveRowFromHeaderTable(final JTable aTable, HeaderTableListener aListener) {
        // remove selected row
        int r = aTable.getSelectedRow();
        if (r == -1) {
            // nothing selected
            return;
        }
        DefaultTableModel model = (DefaultTableModel) (aTable.getModel());
        model.removeRow(r);
        aListener.repopulate(model);
    }

    private void itsRequestContentTextAreaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_itsRequestContentTextAreaKeyReleased
        itsRequestBean.setContent(itsRequestContentTextArea.getText());
        updatePreviewPanel(itsRequestBean);

        // refill the header table, content-length has changed
        initHeaderTable(itsRequestHeadersTable, itsRequestBean);
    }//GEN-LAST:event_itsRequestContentTextAreaKeyReleased

    private void itsFromKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_itsFromKeyReleased
        itsRequestBean.setFromName(itsRequestFromNameTextField.getText());
        itsRequestBean.setFromURI(itsRequestFromUriTextField.getText());
        updatePreviewPanel(itsRequestBean);
    }//GEN-LAST:event_itsFromKeyReleased

    private void itsToKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_itsToKeyReleased
        itsRequestBean.setToName(itsRequestToNameTextField.getText());
        itsRequestBean.setToURI(itsRequestToUriTextField.getText());
        updatePreviewPanel(itsRequestBean);
    }//GEN-LAST:event_itsToKeyReleased

    private void itsRequestUriTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_itsRequestUriTextFieldKeyReleased
        itsRequestBean.setURI(itsRequestUriTextField.getText());
        updatePreviewPanel(itsRequestBean);
    }//GEN-LAST:event_itsRequestUriTextFieldKeyReleased

    private void itsRequestMethodComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestMethodComboBoxActionPerformed
        String method = itsRequestMethodComboBox.getSelectedItem().toString();
        itsRequestBean.setMethod(method);
        // issue 368
        //  Contact: header should not be present if Method is set to BYE
        if ("BYE".equals(method)){
            itsRequestBean.deleteHeaderValue(Constants.CONTACT);
        }
        initHeaderTable(itsRequestHeadersTable, itsRequestBean);
        updatePreviewPanel(itsRequestBean);
    }//GEN-LAST:event_itsRequestMethodComboBoxActionPerformed

    private void itsRequestOkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestOkButtonActionPerformed
        // Done creating request.
        String text = itsRequestPreviewTextArea.getText();
        itsCreationTextArea.setText(text);

        // itsBean no longer needed, new one will be created once form
        // is reopened.
        itsRequestHeaderTableListener.setBean(null);
        itsRequestBean = null;

       // return to first card
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card1");
    }//GEN-LAST:event_itsRequestOkButtonActionPerformed

    private void itsRequestCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsRequestCancelButtonActionPerformed
        // itsBean no longer needed, new one will be created once form
        // is reopened.
        itsRequestHeaderTableListener.setBean(null);
        itsRequestBean = null;

        // return to first card
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card1");
    }//GEN-LAST:event_itsRequestCancelButtonActionPerformed

    private void itsResetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResetButtonActionPerformed
        theirLogger.finest("----- itsResetButtonActionPerformed() ----->");
        // reset Constants to defaults and update GUI
        itsConstants.reset();
        
        LogSupport.initLogging(itsConstants);
        theirLogger = Logger.getLogger(
            "org.jvnet.glassfish.comms.sipagent.ui.AgentMainJPanel");

        this.initConfiguration();

        theirLogger.finest("<----- itsResetButtonActionPerformed() -----");
    }//GEN-LAST:event_itsResetButtonActionPerformed

    private void itsApplyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsApplyButtonActionPerformed
        String historyLimit = itsHistoryLimitField.getText();
        boolean isHistoryLimited = itsHistoryLimitCheckBox.isSelected();

        itsConstants.setProperty(Constants.AGENT_NAME, itsAgentNameField.getText());
        itsConstants.setProperty(Constants.LOG_FILE, itsLogFileField.getText());
        itsConstants.setProperty(Constants.TRANSPORT, itsTransportField.getSelectedItem().toString());
        itsConstants.setProperty(Constants.LOCAL_PORT, itsListeningPortField.getText());
        itsConstants.setProperty(Constants.HOST, itsHostField.getText());
        itsConstants.setProperty(Constants.PORT, itsPortField.getText());

        initAgent();
    }//GEN-LAST:event_itsApplyButtonActionPerformed

    private void itsSendButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsSendButtonActionPerformed

        // send the text currently shown on screen
        try {
            String message = itsCreationTextArea.getText();
            if (message.startsWith("SIP/")) {
                // this is a response... try sending that...
                ResponseBean resp = itsAgent.prepareResponse(message);
                itsAgent.sendMessage(message);
            } else { 
                RequestBean req = itsAgent.prepareRequest(message);
                req.updateCSeq();            
                itsAgent.sendMessage(req.toString());
            }
        } catch (RuntimeException e) {
            theirLogger.severe(LogSupport.stringify(e));
            itsInfoOptionPane.showMessageDialog(this, "Oops... wrong format");
        }
    }//GEN-LAST:event_itsSendButtonActionPerformed

    private void itsNewRequestButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsNewRequestButtonActionPerformed
        String txt = itsCreationTextArea.getText();
        if (txt.startsWith("SIP")) {
            itsResponseBean = itsAgent.prepareResponse(txt);
            openResponseEditor();
        } else {
            itsRequestBean = itsAgent.prepareRequest(txt);
            openRequestEditor(evt,txt);
        }

    }//GEN-LAST:event_itsNewRequestButtonActionPerformed

    private void openRequestEditor(java.awt.event.ActionEvent evt, String initialText) {
        // Fill the RequestEdit window with stuff retrieved from the bean.
        itsRequestFromNameTextField.setText(itsRequestBean.getFromName());
        itsRequestFromUriTextField.setText(itsRequestBean.getFromURI());
        itsRequestToNameTextField.setText(itsRequestBean.getToName());
        itsRequestToUriTextField.setText(itsRequestBean.getToURI());
        itsRequestUriTextField.setText(itsRequestBean.getURI());
        itsRequestMethodComboBox.setSelectedItem(itsRequestBean.getMethod());

        itsRequestContentTextArea.setText(itsRequestBean.getContent());
        updatePreviewPanel(itsRequestBean);

        initHeaderTable(itsRequestHeadersTable, itsRequestBean);

        if (itsRequestHeaderTableListener == null) {
            // first time this button was pressed, add a listener
            itsRequestHeaderTableListener = 
                new HeaderTableListener(this, itsRequestBean);
        } else {
            itsRequestHeaderTableListener.setBean(itsRequestBean);
        }

        // Add a listener to the headers table to make sure any changes are
        // propagated to the underlying RequestBean.
        TableModel model = itsRequestHeadersTable.getModel();
        model.addTableModelListener(itsRequestHeaderTableListener);

        // show request creation panel (card2)
        CardLayout cl = (CardLayout) (itsTopPanel.getLayout());
        cl.show(itsTopPanel, "card2");        
    }
    
    private void itsResponseCodeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itsResponseCodeComboBoxActionPerformed
        String responseCode = (String)itsResponseCodeComboBox.getSelectedItem();
        itsResponseBean.setResponseCode(responseCode);
        updatePreviewPanel(itsResponseBean);
    }//GEN-LAST:event_itsResponseCodeComboBoxActionPerformed

    // ------------------------------------------------------------------------
    //  Package private screen update methods
    // ------------------------------------------------------------------------
    void addToMessageHistory(Object anObject) {
        theirLogger.finest("----- addToMessageHistory() ----->");
        DefaultTableModel model = (DefaultTableModel) itsMessageHistory.getModel();

        // check if the message history has been limited
        if (itsHistoryLimit != HISTORY_UNLIMITED) {
            // it has; check that the number of rows in the model does
            // not exceed the limit.
            if (model.getRowCount() == itsHistoryLimit) {
                // limit reached, make room in the table
                model.removeRow(0);
            }
            // else: room for one more
        }
        // else: history not limited
        // add row at the end
        model.addRow(new Object[]{anObject});

        theirLogger.finest("<----- addToMessageHistory() -----");
    }


    /**
     *  This method can be used to update the message preview area after the
     *  user has made changes to the current message e.g. from elsewhere in the
     *  GUI.
     */
    void updatePreviewPanel(MessageBean aBean) {
        if (aBean instanceof RequestBean) {
            itsRequestPreviewTextArea.setText(aBean.toString());
        } else {
            itsResponsePreviewTextArea.setText(aBean.toString());
        }
    }

    /**
     * Populate headers table, but skip to and from (shown separately)
     * and cseq (calculated based on method).
     */
    private void initHeaderTable(JTable aTable, MessageBean aBean) {
        theirLogger.finest("----- initHeaderTable() ----->");
        DefaultTableModel model = (DefaultTableModel) aTable.getModel();

        // remove rows and repopulate from bean

        // remove rows and repopulate from bean
        int rc = model.getRowCount();
        theirLogger.finest("Removing " + rc + " rows from model");
        for (int i = 0; i < rc; i++) {
            model.removeRow(0);
        }

        Iterator<String> headers = aBean.getHeaders();
        while (headers.hasNext()) {
            String header = headers.next();
            if (!(Constants.FROM.equals(header)) && !(Constants.TO.equals(header))) {
                theirLogger.finest("Adding header " + header + " to JTable");
                String[] values = aBean.getHeaderValues(header);
                for (String v : values) {
                    model.addRow(new String[]{header, v});
                }
            }
        }
        aTable.setModel(model);
        theirLogger.finest("<----- initHeaderTable() -----");
    }

    /**
     *  Initialize config fields based on constant values
     */
    private void initConfiguration() {
        theirLogger.finest("----- initConfiguration() ----->");
        itsConstants.reset();
        String localPort = itsConstants.getProperty(Constants.LOCAL_PORT);
        String agentName = itsConstants.getProperty(Constants.AGENT_NAME) + itsID;
        
        int localPortNr = Integer.parseInt(localPort) + itsID;
        itsConstants.setProperty(Constants.LOCAL_PORT, "" + localPortNr);
        itsConstants.setProperty(Constants.AGENT_NAME, agentName);
        
        itsHostField.setText(itsConstants.getProperty(Constants.HOST));
        itsPortField.setText(itsConstants.getProperty(Constants.PORT));
        itsListeningPortField.setText(itsConstants.getProperty(Constants.LOCAL_PORT));
        itsAgentNameField.setText(itsConstants.getProperty(Constants.AGENT_NAME));
        itsTransportField.setSelectedItem(itsConstants.getProperty(Constants.TRANSPORT));
        theirLogger.finest("<----- initConfiguration() -----");
    }

    void cleanup() {
        theirLogger.finest("----- cleanup() ----->");
        // cleanup resources
        if (itsAgent != null) {
            itsAgent.close();
        }
        itsRequestBean = null;
        itsResponseBean = null;
        itsRequestHeaderTableListener = null;
        itsResponseHeaderTableListener = null;
        theirLogger.finest("<----- cleanup() -----");
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel agentNameFieldLabel;
    private javax.swing.JLabel hostFieldLabel;
    private javax.swing.JButton its200OKButton;
    private javax.swing.JButton itsAckButton;
    private javax.swing.JTextField itsAgentNameField;
    private javax.swing.JButton itsApplyButton;
    private javax.swing.JPanel itsBottomPanel;
    private javax.swing.JButton itsBrowseButton;
    private javax.swing.JButton itsByeButton;
    private javax.swing.JButton itsCancelButton;
    private javax.swing.JMenuItem itsClearHistoryMenuItem;
    private javax.swing.JButton itsCopyMessageButton;
    private javax.swing.JPanel itsCreationPanel;
    private javax.swing.JTextArea itsCreationTextArea;
    private javax.swing.JFileChooser itsFileChooser;
    private javax.swing.JDialog itsFileDialog;
    private javax.swing.JCheckBox itsHistoryLimitCheckBox;
    private javax.swing.JTextField itsHistoryLimitField;
    private javax.swing.JPanel itsHistoryPanel;
    private javax.swing.JPopupMenu itsHistoryPopup;
    private javax.swing.JTextField itsHostField;
    private javax.swing.JDialog itsInfoDialog;
    private javax.swing.JOptionPane itsInfoOptionPane;
    private javax.swing.JTextField itsListeningPortField;
    private javax.swing.JPanel itsLocalConfigPanel;
    private javax.swing.JTextField itsLogFileField;
    private javax.swing.JPanel itsMainPanel;
    private javax.swing.JTable itsMessageHistory;
    private javax.swing.JButton itsNewRequestButton;
    private javax.swing.JTextField itsPortField;
    private javax.swing.JPanel itsRemoteConfigPanel;
    private javax.swing.JMenuItem itsRemoveMessageMenuItem;
    private javax.swing.JButton itsRequestAddHeaderButton;
    private javax.swing.JButton itsRequestButton;
    private javax.swing.JButton itsRequestCancelButton;
    private javax.swing.JScrollPane itsRequestContentPane;
    private javax.swing.JTextArea itsRequestContentTextArea;
    private javax.swing.JButton itsRequestDirectSendButton;
    private javax.swing.JPanel itsRequestEditPanel;
    private javax.swing.JTextField itsRequestFromNameTextField;
    private javax.swing.JPanel itsRequestFromPanel;
    private javax.swing.JTextField itsRequestFromUriTextField;
    private javax.swing.JPanel itsRequestHeadersPanel;
    private javax.swing.JScrollPane itsRequestHeadersScrollPane;
    private javax.swing.JTable itsRequestHeadersTable;
    private javax.swing.JComboBox itsRequestMethodComboBox;
    private javax.swing.JButton itsRequestOkButton;
    private javax.swing.JPanel itsRequestPanel;
    private javax.swing.JScrollPane itsRequestPreviewPane;
    private javax.swing.JTextArea itsRequestPreviewTextArea;
    private javax.swing.JButton itsRequestRemoveHeaderButton;
    private javax.swing.JTextField itsRequestToNameTextField;
    private javax.swing.JPanel itsRequestToPanel;
    private javax.swing.JTextField itsRequestToUriTextField;
    private javax.swing.JTextField itsRequestUriTextField;
    private javax.swing.JButton itsResetButton;
    private javax.swing.JButton itsResponseAddHeaderButton;
    private javax.swing.JButton itsResponseButton;
    private javax.swing.JButton itsResponseCancelButton;
    private javax.swing.JComboBox itsResponseCodeComboBox;
    private javax.swing.JPanel itsResponseCodePanel;
    private javax.swing.JScrollPane itsResponseContentPane;
    private javax.swing.JTextArea itsResponseContentTextArea;
    private javax.swing.JButton itsResponseDirectSendButton;
    private javax.swing.JPanel itsResponseEditPanel;
    private javax.swing.JPanel itsResponseHeadersPanel;
    private javax.swing.JScrollPane itsResponseHeadersScrollPane;
    private javax.swing.JTable itsResponseHeadersTable;
    private javax.swing.JPanel itsResponseLeftPanel;
    private javax.swing.JButton itsResponseOkButton;
    private javax.swing.JScrollPane itsResponsePreviewPane;
    private javax.swing.JTextArea itsResponsePreviewTextArea;
    private javax.swing.JButton itsResponseRemoveHeaderButton;
    private javax.swing.JTextPane itsSelectedMessagePane;
    private javax.swing.JButton itsSendButton;
    private javax.swing.JPanel itsTopPanel;
    private javax.swing.JComboBox itsTransportField;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel listeningPortFieldLabel;
    private javax.swing.JLabel logFileFieldLabel;
    private javax.swing.JScrollPane messageHistoryScollPane;
    private javax.swing.JLabel portFieldLabel;
    private javax.swing.JLabel requestFromUriFieldLabel;
    private javax.swing.JLabel requestFromnameFieldLabel;
    private javax.swing.JLabel requestMethodComboBoxLabel;
    private javax.swing.JLabel requestToNameFieldLabel;
    private javax.swing.JLabel requestUriFieldLabel;
    private javax.swing.JLabel responseCodeComboBoxLabel;
    private javax.swing.JLabel transportFieldLabel;
    // End of variables declaration//GEN-END:variables
}
