/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.sipagent.ui;

import org.jvnet.glassfish.comms.sipagent.support.Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author elnyvbo
 */
public abstract class MessageBean {
   
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.ui.MessageBean");
   
    protected String itsMethod = "";
    protected String itsFromName = "";
    protected String itsFromURI = "";
    protected String itsToName = "";
    protected String itsToURI = "";
    protected String itsContent = ""; // Currently only String content
    protected String itsFromTag = "";
    protected String itsToTag = "";
    
    // Headers are stored in a HashMap mapping header names to multiple values.
    protected HashMap<String, Vector<String>> itsHeaders = 
            new HashMap<String,Vector<String>>();
    
    public String getFromName(){
        return itsFromName;
    }
    public void setFromName(String aFromName){
        itsFromName = aFromName;
    }
    
     public String getToName(){
        return itsToName;
    }
    public void setToName(String aToName){
        itsToName = aToName;
    }
    
    public String getFromURI(){
        return itsFromURI;
    }
    public void setFromURI(String aURI){
        itsFromURI = aURI;
    }
    
    public String getToURI(){
        return itsToURI;
    }
    public void setToURI(String aURI){
        itsToURI = aURI;    
    }
    
    // Tags are copied from the corresponding objects in the model package.
    // They cannot be edited publicly.
    protected String getFromTag(){
        return itsFromTag;
    }
    protected void setFromTag(String aTag) {
        itsFromTag = aTag;
    }
    protected String getToTag(){
        return itsToTag;
    }
    protected void setToTag(String aTag){
        itsToTag = aTag;
    }
    
    
    public String getContent(){
        return itsContent;
    }
    public void setContent(String aContent){
        itsContent = aContent;
        setHeaderValue(Constants.CONTENT_LENGTH, "" + aContent.length());
    }
    
    public Iterator<String> getHeaders(){
        return itsHeaders.keySet().iterator();
    }
    public String[] getHeaderValues(String aKey){
        theirLogger.finest("----- getHeaderValues(" + aKey + ") ----->");
        Vector<String> values = itsHeaders.get(normalize(aKey));
        if (values == null){
            values = new Vector<String>();
        }
        
        String[] result = (String[]) values.toArray(new String[values.size()]);
        
        if (theirLogger.isLoggable(Level.FINEST)) {
            // try to prevent pointless slowness
            StringBuilder logmsg = new StringBuilder("[");
            for (String r : result) { logmsg.append(r).append("   "); }
            theirLogger.finest("<----- getHeaderValues() : " + logmsg.toString() + "] -----");
        }
        return result;
    }
    
    public void addHeaderValue(String aKey, String aValue){
        theirLogger.finest(
            "----- addHeaderValue(" + aKey + ", " + aValue +") ----->");
        
        // normalize to the normal convention of Capital as the first character
        // or one after a '-' sign.
        String aNormalizedKey = normalize(aKey);
        
        // retrieve the current list of values, if any, and add the new value.
        Vector<String> values = itsHeaders.get(normalize(aKey));
        if (values == null){
            values = new Vector<String>();
        }
        values.add(aValue);
        itsHeaders.put(aNormalizedKey, values);
        theirLogger.finest("<----- addHeaderValue() -----");
    }
    
    private void setHeaderValue(String aKey, String aValue){
        theirLogger.finest(
            "----- setHeaderValue(" + aKey + ", " + aValue +") ----->");
        
        // normalize to the normal convention of Capital as the first character
        // or one after a '-' sign.
        String aNormalizedKey = normalize(aKey);
        // replace existing vector of values with new one
        Vector<String> newvalues = new Vector<String>();
        newvalues.add(aValue);
        itsHeaders.put(aNormalizedKey, newvalues);
        theirLogger.finest("<----- setHeaderValue() -----");
    }
    
    void deleteHeaderValue(String aKey){
        theirLogger.finest(
            "----- deleteHeaderValue(" + aKey +") ----->");
        String aNormalizedKey = normalize(aKey);
        itsHeaders.remove(aNormalizedKey);
        theirLogger.finest("<----- deleteHeaderValue() -----");
    }
    
    /**
     * Replace existing (multi-valued) header with an array of new values. 
     * (Helper method for setting a bunch of values in one go).
     */
    void setHeaderValues(String aKey, String[] aValueArray){
        theirLogger.finest("----- setHeaderValues() ----->");
        
        // normalize to the normal convention of Capital as the first character
        // or one after a '-' sign.
        String aNormalizedKey = normalize(aKey);
        // replace existing vector of values with new ones
        Vector<String> newvalues = new Vector<String>();
        
        for (String s : aValueArray){
            newvalues.add(s);
        }
        
        itsHeaders.put(aNormalizedKey, newvalues);
        theirLogger.finest("<----- setHeaderValues() -----");
    }
    
    public String getMethod(){
        return itsMethod;
    }
    public void setMethod(String aMethod){
        itsMethod = aMethod;
        
        theirLogger.finest("----- setMethod(" + aMethod + ") ----->");
        // reformat CSEQ header
        String[] cseqarr = getHeaderValues(Constants.CSEQ);
        if ((cseqarr != null) && (cseqarr.length > 0)){
            String cseq = cseqarr[0];
            // search for last whitespace
            int index = cseq.lastIndexOf(' ');
            if (index!= -1){
                // create new CSEQ value with existing number and new method
                String newcseq = cseq.substring(0, index + 1) + aMethod;
                setHeaderValue(Constants.CSEQ, newcseq);
            }
            else {
                theirLogger.warning("WARNING: malformed CSEQ header!");
            }
        }
        else{
            theirLogger.warning("WARNING: CSEQ header not set!");
        }
        theirLogger.finest("<----- setMethod(" + aMethod + ") -----");
    }
    
 
    void clearHeaders(){
        theirLogger.finest("----- clearHeaders() ----->");
        itsHeaders.clear();
        theirLogger.finest("<----- clearHeaders() -----");
    }
    
    private String normalize(String aValue){
        // CaLl-ID becomes Call-Id
        // CSeq becomes Cseq
        // CoNtEnT-TYPe becomes Content-Type 
        // ... etc.
        StringBuilder  foo = new StringBuilder();
        String [] parts = aValue.split("-");
        for (String part : parts) {
            if (foo.length() > 0) {
                foo.append("-");
            }
            String lc = part.toLowerCase(Locale.ENGLISH);
            foo.append(lc.substring(0,1).toUpperCase(Locale.ENGLISH) + lc.substring(1));
        }
        return foo.toString();
    }
}
