/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.sipagent.ui;

import org.jvnet.glassfish.comms.sipagent.model.SipResponse;
import org.jvnet.glassfish.comms.sipagent.support.Constants;
import java.util.Iterator;
import java.util.logging.Logger;

/**
 *  Bean class for offering a simple interface to the GUI for constructing a SIP
 *  response. The model classes cannot be used for this purpose; those were 
 *  originally designed to be a part of the sailfin SIP Container, which makes
 *  it impossible to manipulate system headers such as Contact, From and To.
 *
 *  This bean class can be manipulated freely, converted to String when done
 *  and then fed into the SipParser for constructing a 'neat' SIP message.
 *
 * @author elnyvbo
 */
public class ResponseBean extends MessageBean{
    
    private static Logger theirLogger =
        Logger.getLogger("org.jvnet.glassfish.comms.sipagent.ui.ResponseBean");
    private String itsResponseCode = "200 OK"; // default
    
    /** Creates a new instance of ResponseBean */
    public ResponseBean(SipResponse aMsg) {
        theirLogger.finest("----- ResponseBean() ----->");
        
        // retrieve stuff from aMsg and cache locally
        setResponseCode(aMsg.getCode());
        setFromName(aMsg.getFromName()); 
        setFromURI(aMsg.getFromURI());
        setToName(aMsg.getToName()); 
        setToURI(aMsg.getToURI());
        setToTag(aMsg.getToTag());
        setFromTag(aMsg.getFromTag());
        
        // copy headers
        Iterator headers = aMsg.getImpl().getHeaderNames();
        while (headers.hasNext()){
            String header = (String)headers.next();
            String value = aMsg.getImpl().getHeader(header);
            this.addHeaderValue(header,value);
        }
        
        setContent(aMsg.getContent());
        theirLogger.finest("<----- ResponseBean() -----");
    }
    
    public ResponseBean(RequestBean aRequest){
        // copy method, from and to
        setMethod(aRequest.getMethod());
        setFromName(aRequest.getFromName());
        setFromURI(aRequest.getFromURI());
        setToName(aRequest.getFromName());
        setToURI(aRequest.getToURI());
        setToTag(aRequest.getToTag());
        setFromTag(aRequest.getFromTag());
        
        // copy other relevant headers
        setHeaderValues(
            Constants.CALL_ID, aRequest.getHeaderValues(Constants.CALL_ID));
        setHeaderValues(
            Constants.CSEQ, aRequest.getHeaderValues(Constants.CSEQ));
        setHeaderValues(Constants.CONTENT_LENGTH, new String[]{""+0});
        setHeaderValues(Constants.VIA, aRequest.getHeaderValues(Constants.VIA));
    }
    
    public String getResponseCode(){
        return itsResponseCode;
    }
    public void setResponseCode(String aResponseCode){
        itsResponseCode = aResponseCode;
    }
    
    public String toString(){
        final String SP = " ";
        final String CRLF = Constants.CRLF;
        final String FROM = Constants.FROM;
        final String TO = Constants.TO;
        
        final String FROMTAG = this.getFromTag();
        final String TOTAG = this.getToTag();
        
        StringBuilder result = new StringBuilder(
            "SIP/2.0" + SP + getResponseCode() + CRLF
            + FROM + ": \"" + getFromName() + "\" <" + getFromURI() +  ">");
        
        // add tag if present
        if ((!"".equals(FROMTAG)) && (FROMTAG != null)){
            result.append(";tag=").append(FROMTAG);
        }
        
        result.append(
            CRLF + TO + ": \"" + getToName() + "\" <" + getToURI() + ">");
        
        // add tag if present
        if ((!"".equals(TOTAG)) && (TOTAG != null)){
            result.append(";tag=" + TOTAG);
        }
        
        result.append(CRLF);
        
        Iterator<String> headers = getHeaders();
        while (headers.hasNext()){
            String header = headers.next();
            // skip from and to as we've just added those
            if (!(FROM.equals(header))&&!(TO.equals(header))){
                String[] values = getHeaderValues(header);
                for (String s : values){
                    result.append(header).append(": ").append(s).append(CRLF);                    
                }
            }
        }
        result.append(CRLF + getContent());
            
        return result.toString();
    }
    
}
