/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.jbi.jsf.util;

import com.sun.enterprise.tools.admingui.tree.FilterTreeEvent;
import com.sun.enterprise.tools.admingui.util.JMXUtil;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptor;
import com.sun.jsftemplating.component.factory.tree.TreeAdaptorBase;
import com.sun.jsftemplating.util.Util;

import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.event.CommandActionListener;

import java.lang.reflect.Constructor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Map;
import java.util.Properties;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;


/**
 *  <p> The <code>JBITreeAdaptor</code> implementation must have a
 *	<code>public static JBITreeAdaptor getInstance(FacesContext,
 *	LayoutComponent, UIComponent)</code> method in order to get access to
 *	an instance of the <code>JBITreeAdaptor</code> instance.</p>
 *
 *  <p>	This class is used by <code>DynamicTreeNodeFactory</code>.</p>
 *
 *
 */
public class JBIHookTreeAdaptor extends TreeAdaptorBase 
   implements TreeAdaptor			      
{
   
    private static Logger sLog = 
	Logger.getLogger("com.sun.jbi.jsf.util");

    /**
     *	<p> This constructor is not used.</p>
     */
    private JBIHookTreeAdaptor() 
    {
    }

    /**
     *	<p> This constructor saves the <code>LayoutComponent</code> descriptor
     *	    and the <code>UIComponent</code> associated with this
     *	    <code>TreeAdaptor</code>.  This constructor is used by the
     *	    getInstance() method.</p>
     */
    protected JBIHookTreeAdaptor(LayoutComponent desc, UIComponent parent) 
    {
	super(desc, parent);
    }

    /**
     *	<p> This method provides access to an <code>JBIHookTreeAdaptor</code>
     *	    instance.  Each time it is invoked, it returns a new instance.</p>
     */
    public static TreeAdaptor getInstance(FacesContext ctx, LayoutComponent desc, UIComponent parent) 
    {
	final String IMPL_CLASS_NAME = "com.sun.jbi.jsf.util.JBITreeAdaptorImpl";

	TreeAdaptor result = new JBIHookTreeAdaptor(desc, parent); // fall-back to this

	sLog.fine("JBIHookTreeAdaptor.getInstance(" + ctx + 
		  ", " + desc + ", " + parent + "), result=" + result);
	try
	    {
		Class implClass = Class.forName(IMPL_CLASS_NAME);

		Class ctorArgTypes[] = new Class[2];
		ctorArgTypes[0] = LayoutComponent.class;
		ctorArgTypes[1] = UIComponent.class;
		Constructor ctor 
		    = implClass.getConstructor(ctorArgTypes);
		Object ctorArgValues[] = new Object[2];
		ctorArgValues[0] = desc;
		ctorArgValues[1] = parent;
		Object newInstance = ctor.newInstance(ctorArgValues);
		result = 
		    (TreeAdaptorBase) newInstance;
		sLog.fine("JBIHookTreeAdaptor.getInstance(" + ctx + 
			  ", " + desc + 
			  ", " + parent + "), implClass=" + implClass);

	    }
	catch (Exception ex)
	    {
		sLog.log(Level.FINE,
			 "JBIHookTreeAdaptor.getInstance(" + ctx + 
			 "," + desc + 
			 ", " + parent + "), caught Exception",
			 ex);
	    }
	finally
	    {
		sLog.fine("JBIHookTreeAdaptor.getInstance(" + ctx + 
			  ", " + desc +
			  ", " + parent + "), finally result=" + result);
	    }

	return result;
    }

    /**
     * The following methods are required in order to make this non-abstract class
     * instantiatable, but when this placeholder object is returned, there is no
     * JBI implementation available, so these methods should never get called.
     */
    public List getChildTreeNodeObjects(Object nodeObject) 
    {
        List result = new ArrayList();
	sLog.fine("JBIHookTreeAdaptor.getChildTreeNodeObjects(...) no-op (missing JBI)");
	return result;
    }
    public Map<String, UIComponent> getFacets(UIComponent comp, Object nodeObject) 
    {
        Map result = new HashMap();
	sLog.fine("JBIHookTreeAdaptor.getFacets(...) no-op (missing JBI)");
        return result;
    }
    public Map<String, Object> getFactoryOptions(Object nodeObject) 
    {
        Map<String, Object> result = new HashMap();
	sLog.fine("JBIHookTreeAdaptor.getFactoryOptions(...) no-op (missing JBI)");
	return result;
    }
    public String getId(Object nodeObject) 
    {
        String result = "nullNodeObject";
	sLog.fine("JBIHookTreeAdaptor.getId(...) no-op (missing JBI)");
        return result;
    }

}
