/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin;

import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConvergedLbConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LoadbalancerReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.impl.LoadbalancerReaderImpl;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.LoadbalancerVisitor;
import org.jvnet.glassfish.comms.clb.admin.Loadbalancer;
import org.jvnet.glassfish.comms.clb.admin.ObjectFactory;
import org.jvnet.glassfish.comms.util.LogUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.util.i18n.StringManagerBase;

/**
 * Class to publish the converged-loadbalancer.xml to config directory.
 *
 * @author Vijaya Gadhamsetty
 */
public class ClbConfigPublisher {
    private Loadbalancer _lb = null;
    private String _name = null;
    private String _lbName = null;
    private ConfigContext _ctx = null;
    private String _configName = null;
    private static Logger _logger = LogUtil.SIP_LOGGER.getLogger();
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager(_logger.getResourceBundleName());

    /** Creates a new instance of ClbConfigPublisher */
    public ClbConfigPublisher(ConfigContext ctx, String clbConfigName,
        String lbName, String configName) throws IOException {
        _name = clbConfigName;
        _lbName = lbName;
        _ctx = ctx;
        _configName = configName;
    }

    public LoadbalancerReader getLbReader(ConfigContext ctx,
        String clbConfigName) throws ConfigException {
        // reads the load balancer related data
        ConvergedLbConfig clbConfig = ((Domain) ctx.getRootConfigBean()).getConvergedLbConfigs()
                                       .getConvergedLbConfigByName(clbConfigName);

        return new LoadbalancerReaderImpl(ctx, clbConfig);
    }

    /**
     * publishes the converged-loadbalancer.xml to config directory.
     * @throws java.io.IOException
     * @throws com.sun.enterprise.config.ConfigException
     */
    public String publish(String fileName) throws IOException, ConfigException {
        String iRoot = System.getProperty(SystemPropertyConstants.INSTANCE_ROOT_PROPERTY);
        String filePath = null;

        String newConfigFileName = ClbAdminEventHelper.getConfigFileNewValue(fileName);
        _logger.log(Level.FINE, "The New config-file name is " + newConfigFileName);
        File f = new File(newConfigFileName);

        if (!f.isAbsolute()) {
            filePath = iRoot + File.separator + PEFileLayout.CONFIG_DIR + File.separator + 
                                            _configName + File.separator + newConfigFileName;
        } else {
            filePath = newConfigFileName;
        }

        // check if the lb exists
        LoadbalancerReader lbr = getLbReader(_ctx, _name);
        FileOutputStream out = null;

        try {
            out = new FileOutputStream(filePath);

            // tranform the data using visitor pattern
            Loadbalancer _lb = new Loadbalancer();

            LoadbalancerVisitor lbVstr = new LoadbalancerVisitor(_lb);
            lbr.accept(lbVstr);

            ObjectFactory clbFactory = new ObjectFactory();
            clbFactory.store(_lb, out);
            out.flush();
            // Do not delete the old config files if debug is set as true
            if (!ClbAdminEventHelper.isClbDebug()) {
                filePath = iRoot + File.separator + PEFileLayout.CONFIG_DIR + File.separator + _configName + File.separator + fileName;
                _logger.log(Level.INFO,
                                 _sMgr.getString("sip.clbadmin.deleting_configfile",filePath));
                File oldFile = new File(filePath);
                if (oldFile.exists())
                    oldFile.delete();
            }
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        } finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
        return newConfigFileName;
    }
}
