/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.impl;

import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import org.jvnet.glassfish.comms.util.LogUtil;

import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.WebModuleReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Impl class for ClusterReader. This provides loadbalancer
 * data for a cluster.
 *
 * @author Vijaya Gadhamsetty
 */
public class ClusterReaderHelper {
    private static final StringManager _strMgr = StringManager.getManager(ClusterReaderHelper.class);
    private static Logger _logger = LogUtil.SIP_LOGGER.getLogger();
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager(_logger.getResourceBundleName());
    private static final String EX_MOD_TYPE = "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    private static final String IS_CONVERGED = "isConverged";

    /**
     * Returns the web module readers for a set of application refs.
     *
     * @param   _configCtx      Current Config context
     * @param   refs            Application ref(s) from cluster or stand alone
     *                          instance
     * @param   target          Name of the cluster or stand alone instance
     *
     * @return  WebModuleReader[]   Array of the corresponding web module
     *                              reader(s).
     *
     * @throws  LbReaderException   In case of any error(s).
     */
    public static WebModuleReader[] getWebModules(ConfigContext _configCtx,
        ApplicationRef[] refs, String target) throws LbReaderException {
        List list = new ArrayList();

        for (int i = 0; i < refs.length; i++) {
            String name = refs[i].getRef();

            if (!refs[i].isEnabled()) {
                continue;
            }

            ConfigBean bean = null;

            try {
                bean = ApplicationHelper.findApplication(_configCtx, name);
            } catch (ConfigException ce) {
                String msg = _strMgr.getString("ErrorFindingApplication", name,
                        target);
                throw new LbReaderException(msg, ce);
            }

            LocationHelper lhelper = new LocationHelper(_configCtx);

            if (bean instanceof WebModule) {
                WebModule wMod = (WebModule) bean;

                if ((wMod != null) &&
                        (wMod.getObjectType().equals(IAdminConstants.USER))) {
                    String l = lhelper.getSunWebXmlPathForModule(wMod.getName());
                    WebModuleReader wr = new WebModuleReaderImpl(_configCtx,
                            refs[i], bean, createSunWebApp(l));
                    list.add(wr);
                }
            } else if (bean instanceof ExtensionModule) {
                ExtensionModule exMod = (ExtensionModule) bean;
                
                if (exMod != null &&
                        exMod.getObjectType().equals(IAdminConstants.USER) &&
                        exMod.getModuleType().equals(EX_MOD_TYPE) &&
                        Boolean.parseBoolean(exMod.getElementPropertyByName(IS_CONVERGED).getValue())) {
                    WebModuleReader wr = new ExtensionModuleReaderImpl(_configCtx,
                            refs[i], bean);
                    list.add(wr);
                }
            } else if (bean instanceof J2eeApplication) {
                J2eeApplication app = (J2eeApplication) bean;

                if ((app != null) &&
                        (app.getObjectType().equals(IAdminConstants.USER))) {
                    // get all the web modules inside application
                    List l = lhelper.getSunWebXmlPathForApplication(app.getName());
                    int size = l.size();

                    for (int j = 0; j < size; j++) {
                        WebModuleReader wr = new WebModuleReaderImpl(_configCtx,
                                refs[i], null,
                                createSunWebApp((String) l.get(j)));
                        list.add(wr);
                    }

                    List l1 = lhelper.getSunEjbJarXmlPathForApplication(app.getName());
                    int size1 = l1.size();

                    for (int j = 0; j < size1; j++) {
                        List<WebserviceEndpoint> wsepList = createWebserviceEndpoint((String) l1.get(
                                    j));

                        for (WebserviceEndpoint wsep : wsepList) {
                            WebModuleReader wr = new EjbJarModuleReaderImpl(_configCtx,
                                    refs[i], wsep);
                            list.add(wr);
                        }
                    }
                }
            }
        }

        // returns the web module reader as array
        WebModuleReader[] webModules = new WebModuleReader[list.size()];

        return (WebModuleReader[]) list.toArray(webModules);
    }

    /**
     * Create SunWebApp bean from the file.
     *
     * @param   String      location of sun-web.xml. (full path, including
     *                      directory and file name).
     *
     * @returns SunWebApp   bean representation.
     *
     * @throws  LbReaderException   In case of any error(s).
     */
    public static SunWebApp createSunWebApp(String l) throws LbReaderException {
        FileInputStream in = null;

        try {
            in = new FileInputStream(new File(l));
        } catch (FileNotFoundException fne) {
            _logger.log(Level.WARNING,
                _sMgr.getString("sip.clbadmin.sunweb.xml.not.found", l));
        }

        SunWebApp sw = null;

        try {
            sw = SunWebApp.createGraph(in);
        } catch (Exception e) {
            _logger.log(Level.WARNING,
                _sMgr.getString("sip.clbadmin.sunweb.bean.create.failed", e));
        }

        return sw;
    }

    public static List<WebserviceEndpoint> createWebserviceEndpoint(String l)
        throws LbReaderException {
        FileInputStream in = null;

        try {
            in = new FileInputStream(new File(l));
        } catch (FileNotFoundException fne) {
            _logger.log(Level.WARNING,
                _sMgr.getString("sip.clbadmin.sunejbjar.xml.not.found", l));
        }

        SunEjbJar se = null;
        List<WebserviceEndpoint> list = new ArrayList<WebserviceEndpoint>();

        try {
            se = SunEjbJar.createGraph(in);

            EnterpriseBeans beans = se.getEnterpriseBeans();
            Ejb[] ejbs = beans.getEjb();

            for (Ejb ejb : ejbs) {
                WebserviceEndpoint[] wseps = ejb.getWebserviceEndpoint();
                list.addAll(Arrays.asList(wseps));
            }
        } catch (Exception e) {
            _logger.log(Level.WARNING,
                _sMgr.getString("sip.clbadmin.ejbjar.bean.create.failed", e));
        }

        return list;
    }
}
