/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.impl;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.util.i18n.StringManager;

import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.WebModuleReader;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.Visitor;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.WebModuleVisitor;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Provides web module information relavant to Load balancer tier.
 *
 * @author Vijaya Gadhamsetty
 */
public class WebModuleReaderImpl implements WebModuleReader {
    private static final StringManager _strMgr = StringManager.getManager(WebModuleReaderImpl.class);

    // ---- VARIABLE(S) - PRIVATE -----------------------------
    private ApplicationRef _applicationRef = null;
    private SunWebApp _bean = null;
    private WebModule _wm = null;

    public WebModuleReaderImpl(ConfigContext ctx, ApplicationRef ref,
        ConfigBean wm, SunWebApp bean) {
        if (wm != null) {
            if (wm instanceof WebModule) {
                _wm = (WebModule) wm;
            } else {
                String msg = _strMgr.getString("UnknownTypeInWebModuleReader");
                throw new RuntimeException(msg);
            }
        } else {
            _wm = null;
        }

        _applicationRef = ref;
        _bean = bean;
    }

    public String getContextRoot() throws LbReaderException {
        // Web module bean can have context root 
        // first get the context root from domain.xml.
        // If context root is not availble in domain.xml, get it from
        // sun-web.xml.
        String context = null;

        if (_wm != null) {
            context = _wm.getContextRoot();
        }

        if (context == null) {
            context = _bean.getContextRoot();
        }

        return context;
    }

    public void accept(Visitor v) {
        WebModuleVisitor wv = (WebModuleVisitor) v;
        wv.visit(this);
    }
}
