/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.cli.extensions.commands;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.cli.commands.StartDomainCommand;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;

import com.sun.enterprise.config.serverbeans.SipListener;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.config.ConfigFactory;

/**
 *  Command to start the domain
 */
public class ExtStartDomainCommand extends StartDomainCommand
{

    public void runCommand() throws CommandException, CommandValidationException
    {
        String domainName = null;
        try {
            domainName = getDomainName();
            DomainConfig config = getDomainConfig(domainName);
            DomainsManager mgr = getFeatureFactory().getDomainsManager();
            InstancesManager im = mgr.getInstancesManager(config);
            int state = im.getInstanceStatus();
            boolean printMessage = (state == Status.kInstanceNotRunningCode);
            super.runCommand();
   
            if (printMessage) {
                String xmlPath = new PEFileLayout(config).getDomainConfigFile().getAbsolutePath();
                ConfigContext cc = ConfigFactory.createConfigContext(xmlPath);
                String sipPortsUsed = getSipListenerPorts(cc);
                CLILogger.getInstance().printDetailMessage(
                            getLocalizedString("PortsSipContainer", new Object[] {sipPortsUsed}));
            }
            
        } catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            domainName = domainName==null?getLocalizedString("Undefined"):domainName;
            throw new CommandException(getLocalizedString("CannotStartDomain",
                       new Object[] {domainName}), e);
        }
        
    }
    
    /*
     * Return the sip ports used by the server
     */
    public String getSipListenerPorts(ConfigContext cc) throws ConfigException {
        String sp = "";
        final SipListener[] sls = ServerHelper.getConfigForServer(cc, SystemPropertyConstants.DEFAULT_SERVER_INSTANCE_NAME).getSipService().getSipListener();
        int cnt=0;
        for (final SipListener sl : sls) {
            if (sl.isEnabled()) {
                if (cnt != 0)
                    sp += ", ";
                if (sl.getTransport().equals("udp_tcp"))
                    sp += "SIP ";
                else if (sl.getTransport().equals("tls"))
                    sp += "SIPS ";
                sp += sl.getAddress() + ":";
                sp += sl.getPort();
                cnt++;
            }
        }

        return sp;
    }
}