/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.util;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;


/**
 *
 * @author irfan
 */
public class SipSecurityHelper {
    /** This represents the security-service per config. You need to supply ,config=<config-name> */
    public static final String CONFIG_SECURITY_SERVICE_OBJECTNAME = 
            "com.sun.appserv:type=security-service,category=config";
    private static final List trustConfigAttributes = new ArrayList();
    static {
	trustConfigAttributes.add("is-default");
    };
    
    public static ObjectName getSecurityServiceObject(String configName) throws Exception{
        String secServiceObjectName = CONFIG_SECURITY_SERVICE_OBJECTNAME + ",config=" + configName;
        return new ObjectName(secServiceObjectName);
    }

    public interface SipTrustHandlerKeys {
	public static final String ELEMENT_NAME	= "trust-handler";
	public static final String CLASS_NAME	= "class-name";
    }
    
    public interface SipTrustEntityKeys {
	public static final String ELEMENT_NAME = "trust-entity";
    }
    
    public static final String[] trustedEntityAttributes = {
	"id", "trusted-as", "ip-address", "host-name", "principal"
    };
    
    public static List getTrustConfigs(String configName) throws Exception{
        ObjectName secService = getSecurityServiceObject(configName);
        ObjectName[] trustConfigs = (ObjectName[]) SipUtil.getChildByFunction(secService, 
                "getIdentityAssertionTrust", null, null);
        if(trustConfigs != null) {
            return Arrays.asList(trustConfigs);
        } else {
            return null;
        }
    }

    public static ObjectName getTrustConfig(String configName, String trustConfigID) throws Exception{
	ObjectName secService = getSecurityServiceObject(configName);
        ObjectName trustConfig = (ObjectName) SipUtil.getChildByFunction(secService, 
		"getIdentityAssertionTrustById",
		new Object[]{trustConfigID}, new String[]{"java.lang.String"});
	return trustConfig;
    }
    
    public static String getTrustConfigType(ObjectName trustConfig) throws Exception{
        String type = "Trust Entities";
        ObjectName[] entities = (ObjectName[]) SipUtil.getChildByFunction(trustConfig, "getTrustedEntity");
        if((entities == null) || (entities.length == 0)) {
            ObjectName trustHandler = (ObjectName) SipUtil.getChildByFunction(trustConfig, 
                    "getTrustHandler");
            if(trustHandler != null) {
                type = "Trust Handler";
            }
        }
        return type;
    }

    public static void createTrustConfig(String configName, HashMap map) throws Exception{
        // create the attr list
        HashMap attrMap  = new HashMap();
        attrMap.put("id", (String) map.get("name"));
        attrMap.put("is-default", map.get("default").toString());
        AttributeList attrList = SipUtil.convertMapToAttributeList(attrMap);
        
        String selected = (String) map.get("trustTypeOption");
        AttributeList entityList = new AttributeList();
        Properties handlerProps = new Properties();
        
        if("entity".equals(selected)) {
            attrMap.clear();
            attrMap.put("id", (String) map.get("entityName"));
            String trustedAs = (String) map.get("entityTrustedAs");
            if (!GuiUtil.isEmpty(trustedAs)) {
                attrMap.put("trusted-as", trustedAs);
            }
            attrMap.put("ip-address", (String) map.get("entityIPAddress"));
            attrMap.put("host-name", (String) map.get("entityDomainName"));
            attrMap.put("principal", (String) map.get("entityPrincipal"));
            entityList = SipUtil.convertMapToAttributeList(attrMap);
        } else {
            //trust handler
            String className = (String) map.get("handlerClassName");
            Attribute handlerClassNameAttr = new Attribute("class-name", className);
            attrList.add(handlerClassNameAttr);
            HashMap newProps = (HashMap) map.get("handlerProps");
            if ((newProps != null) && (newProps.size() > 0)) {
                handlerProps.putAll(newProps);
            } else {
                newProps = null;
            }
        }
        
        ObjectName sipConfigsObject = SipUtil.getSipConfigsObject();
        Object params[] = {attrList, entityList, handlerProps, configName};
        String types[] = {attrList.getClass().getName(), entityList.getClass().getName(), 
            handlerProps.getClass().getName(), configName.getClass().getName()};
        JMXUtil.invoke(sipConfigsObject, "createIdentityAssertionTrust", params, types);
    }

    public static void deleteTrustConfig(String configName, String id) throws Exception{
        Object params[] = {id, configName};
        String types[] = SipUtil.getSignatureArray(params);
        ObjectName sipConfigsObject = SipUtil.getSipConfigsObject();
        JMXUtil.invoke(sipConfigsObject, "deleteIdentityAssertionTrust", params, types);
    }

    public static String[] getSipTrustHandlerAttributes() {
	return new String[] {
	    SipTrustHandlerKeys.CLASS_NAME
	};
    }
    
    public static HashMap getTrustConfigInfo(String trustConfigName, String configName) throws Exception {
	HashMap map = new HashMap();
	map.put("name", trustConfigName);
	map.put("configName", configName);
	
	ObjectName secService = getSecurityServiceObject(configName);
	ObjectName trustConfig = (ObjectName) SipUtil.getChildByFunction(secService, 
		"getIdentityAssertionTrustById", new Object[]{trustConfigName}, 
		new String[]{"java.lang.String"});
	String type = getTrustConfigType(trustConfig);
	map.put("type", type);
	if (type.equals("Trust Entities")) {
	    map.put("showEntitySection", true);
	    map.put("showHandlerSection", false);
	    map.put("pageTitle", "Edit Trust Entities");
	    map.put("pageTitleHelp", "Click on a trust entity to edit the same.");
	    ArrayList entities = (ArrayList) getTrustConfigEntityInfo(trustConfig);
	    map.put("trustedEntities", entities);
	} else {
	    map.put("showEntitySection", false);
	    map.put("showHandlerSection", true);
	    map.put("pageTitle", "Edit Trust Handler");
	    map.put("pageTitleHelp", "Edit the selected trust handler.");
	    getTrustHandlerInfo(trustConfig, map);
	}
	
	// add attributes for trust config
	String[] attributeList = (String[]) trustConfigAttributes.toArray(
		new String[trustConfigAttributes.size()]);
	HashMap attributes = SipUtil.getAttributeValues(trustConfig, attributeList, true);
	map.putAll(attributes);
	map.put("isDefault", Boolean.valueOf((String) map.get("isDefault")));
	return map;
    }
    
    public static void getTrustHandlerInfo(ObjectName trustConfig, HashMap map) throws Exception{
	ObjectName trustHandler = (ObjectName) SipUtil.getChildByFunction(trustConfig, "getTrustHandler");
	if (trustHandler != null) {
	    HashMap attributes = SipUtil.getAttributeValues(trustHandler, getSipTrustHandlerAttributes());
	    map.put("trustHandler_className", attributes.get(SipTrustHandlerKeys.CLASS_NAME));
	    HashMap properties = SipUtil.getProperties(trustHandler);
	    map.put("trustHandler_props", properties);
	}
    }
    
    public static void saveTrustHandlerInfo(ObjectName trustConfig, HashMap attMap,
	    HashMap addProps, ArrayList removeProps) throws Exception {
	
	ObjectName trustHandler = (ObjectName) SipUtil.getChildByFunction(trustConfig, "getTrustHandler");
	if (trustHandler != null) {
	    HashMap saveAttrMap = new HashMap();
	    saveAttrMap.put(SipTrustHandlerKeys.CLASS_NAME, attMap.get("trustHandler_className"));
	    SipUtil.setAttributeValues(trustHandler, saveAttrMap);
	    
	    SipUtil.setProperties(trustHandler, addProps, removeProps);
	}
    }
    
    public static List getTrustConfigEntityInfo(ObjectName trustConfig)
	    throws Exception {
	ArrayList list = new ArrayList();
	String entityNames[] = (String[]) SipUtil.getChildByFunction(trustConfig, 
		"getTrustedEntityNamesList");
	for (String name: entityNames) {
	    HashMap oneRow = new HashMap();
	    oneRow.put("trustConfigName", trustConfig.getKeyProperty("id"));
	    oneRow.put("name", name);
	    ObjectName trustedEntity = (ObjectName) SipUtil.getChildByFunction(trustConfig, 
		    "getTrustedEntityById", new Object[]{name},
		    new String[]{"java.lang.String"});
	    HashMap attributes = SipUtil.getAttributeValues(trustedEntity, 
		    trustedEntityAttributes);
	    oneRow.put("trustedAs", attributes.get("trusted-as"));
            String ipAddress = (String) attributes.get("ip-address");
            if (ipAddress == null) {
                ipAddress = "";
            }
	    oneRow.put("ipAddress", ipAddress);
            
            String hostName = (String) attributes.get("host-name");
            if (hostName == null) {
                hostName = "";
            }
	    oneRow.put("hostName", hostName);
	    oneRow.put("selected", false);
	    list.add(oneRow);
	}
	return list;
    }
    
    public static HashMap getTrustedEntityInfo(ObjectName trustConfig, String entityName) 
	    throws Exception {
	HashMap map = new HashMap();
	map.put("entityName", entityName);
	ObjectName trustedEntity = (ObjectName) SipUtil.getChildByFunction(trustConfig, "getTrustedEntityById",
		new Object[]{entityName}, new String[]{"java.lang.String"});
	if (trustedEntity != null) {
	    HashMap attributes = SipUtil.getAttributeValues(trustedEntity, trustedEntityAttributes);
	    map.put("entityTrustedAs", attributes.get("trusted-as"));
	    String ipAddress = (String) attributes.get("ip-address");
            if (ipAddress == null) {
                ipAddress = "";
            }
	    map.put("entityIPAddress", ipAddress);
            
            String hostName = (String) attributes.get("host-name");
            if (hostName == null) {
                hostName = "";
            }
            map.put("entityDomainName", hostName);
            
            String principal = (String) attributes.get("principal");
            if (principal == null) {
                principal = "";
            }
            map.put("entityPrincipal", principal);
	}
	
	return map;
    }

    public static List getTrustConfigAttributes() {
	return trustConfigAttributes;
    }
}
