/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.admin.gui.extensions.util;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.MessageUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;


/**
 *
 * @author irfan
 */
public class SipUtil {
    
    public static final String SIP_MODULE_TYPE = 
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    public static final String APP_OBJECT_NAME = "com.sun.appserv:type=applications,category=config";
    public static final String SIP_CONFIG_OBJECT_NAME   = "com.sun.appserv:type=config,category=config";
    public static final String SIP_CONFIGS_OBJECT_NAME  = "com.sun.appserv:type=sip-configs,category=config";
    
    public static final String RESOURCE_NAME            = "sip";
    public static final String SIP_RESOURCE_BUNDLE      = "org.jvnet.glassfish.comms.admin.gui.extensions.resources.Strings";
    
    public static String[] COMMON_CIPHERS = {
            "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA",
            "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA",
            "SSL_RSA_WITH_3DES_EDE_CBC_SHA"
        };
    public static String[] BIT_CIPHERS = {
            "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA",
            "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5",
            "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA",
            "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA",
            "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"
        };
    
    public static AttributeList EMPTY_LIST = new AttributeList();
    
    
    public static interface RequestProcessingKeys {
        public static final String THREAD_COUNT_KEY                 =	"thread-count";
        public static final String INITIAL_THREAD_COUNT_KEY         =	"initial-thread-count";
        public static final String THREAD_INCREMENT_KEY             =	"thread-increment";
        public static final String REQUEST_TIMEOUT_IN_SECONDS_KEY	=	"request-timeout-in-seconds";
        public static final String HEADER_BUFFER_LENGTH_IN_BYTES_KEY=	"header-buffer-length-in-bytes";
    }
    
    public static interface KeepAliveKeys {
        public static final String THREAD_COUNT         =   "thread-count";
        public static final String TIMEOUT_IN_SECONDS   =   "timeout-in-seconds";
        public static final String MAX_CONNECTIONS      =   "max-connections";
    }
    
    public static interface ConnectionPoolKeys {
        public static final String QUEUE_SIZE_IN_BYTES          =   "queue-size-in-bytes";
        public static final String RECEIVE_BUFFER_SIZE_IN_BYTES =   "receive-buffer-size-in-bytes";
        public static final String MAX_PENDING_COUNT            =   "max-pending-count";
        public static final String SEND_BUFFER_SIZE_IN_BYTES    =   "send-buffer-size-in-bytes";
    }
    
    public static interface SipProtocolKeys {
        public static final String ERROR_RESPONSE_ENABLED               = "error-response-enabled";
        public static final String DEFAULT_TCP_TRANSPORT                = "default-tcp-transport";
        public static final String CONNECTION_ALIVE_TIMEOUT_IN_SECONDS  = "connection-alive-timeout-in-seconds";
        public static final String MAX_QUEUE_LENGTH                     = "max-queue-length";
        public static final String WRITE_TIMEOUT_IN_MILLIS              = "write-timeout-in-millis";
        public static final String WRITE_TIMEOUT_RETRIES                = "write-timeout-retries";
        public static final String T1_IN_MILLIS                         = "t1-in-millis";
        public static final String T2_IN_MILLIS                         = "t2-in-millis";
        public static final String T4_IN_MILLIS                         = "t4-in-millis";
    }
    
    
    public static ObjectName getSipConfigsObject() throws Exception{
        try {
            return new ObjectName(SIP_CONFIGS_OBJECT_NAME);
        } catch (Exception ex) {
            if (ex instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
    }
    
    /**
     * The function returns the properties for the element represented by the configMBean
     * @param configBean ObjectName representation of the element
     * @return HashMap of properties.
     */
    public static HashMap getProperties(ObjectName configBean) {
        HashMap props = new HashMap();

        try {
            AttributeList attributes = (AttributeList) JMXUtil.invoke(configBean,
                    "getProperties", null, null);
            Iterator<Attribute> it = attributes.iterator();

            while (it.hasNext()) {
                Attribute attribute = it.next();
                String name = attribute.getName();
                Object value = attribute.getValue();
                props.put(name, ((value == null) ? " " : value.toString()));
            }
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }

        return props;
    }

    /**
     * The function sets the properties on an element. The function takes the element bean, map of added
     *  properties and an list of names of properties that are to be removed
     * @param objectName ObjectName representation of the element
     * @param addProps Map of properties to be added
     * @param removeProps ArrayList of property names to be removed
     */
    public static void setProperties(ObjectName objectName, HashMap addProps,
        ArrayList removeProps) {
        if ((removeProps != null) && (removeProps.size() > 0)) {
            Iterator<String> it = removeProps.iterator();

            while (it.hasNext()) {
                Attribute attribute = new Attribute(it.next(), null);
                JMXUtil.invoke(objectName, "setProperty",
                    new Object[] { attribute },
                    new String[] { "javax.management.Attribute" });
            }
        }

        if ((addProps != null) && (addProps.size() > 0)) {
            Iterator<String> it = addProps.keySet().iterator();

            while (it.hasNext()) {
                String propName = it.next();
                Attribute attribute = new Attribute(propName,
                        addProps.get(propName));
                JMXUtil.invoke(objectName, "setProperty",
                    new Object[] { attribute },
                    new String[] { "javax.management.Attribute" });
            }
        }
    }

    /** The function sets the value of a single property on an element
     */
    public static void setProperty(ObjectName element, String propName,
        Object propValue) {
        Attribute attribute = new Attribute(propName, propValue);
        JMXUtil.invoke(element, "setProperty", new Object[] { attribute },
            new String[] { "javax.management.Attribute" });
    }

    /**
     * The function sets a single property on an element
     * @param objectName ObjectName representation of the element
     * @param propName
     * @param propValue
     */
    public static void setProperty(ObjectName objectName, String propName,
        String propValue) {
        Attribute attribute = new Attribute(propName, propValue);

        if (GuiUtil.isEmpty(propValue)) {
            //remove the property
            attribute = new Attribute(propName, null);
        }

        JMXUtil.invoke(objectName, "setProperty", new Object[] { attribute },
            new String[] { "javax.management.Attribute" });
    }

    /**
     * The function returns the attributes for an element. The function takes as input the ObjectName
     *  representation of the element and a string array of attribute names
     * @param objectName ObjectName representation of the element
     * @param propNames String array of attribute names.
     * @return
     */
    public static HashMap getAttributeValues(ObjectName objectName, String[] propNames,
	    boolean changeCase) {
        HashMap props = new HashMap();

        try {
            for (String attributeName : propNames) {
                Object value = JMXUtil.getAttribute(objectName, attributeName);
		if (changeCase) {
		    attributeName = toCamelCase(attributeName);
		}
                props.put(attributeName,
                    ((value == null) ? " " : value.toString()));
            }

            return props;
        } catch (Exception ex) {
            return null;
        }
    }

    public static HashMap getAttributeValues(ObjectName objectName, String[] propNames) {
	return getAttributeValues(objectName, propNames, false);
    }
    /**
     * The function sets the attribute values for a given element
     * @param objectName ObjectName representation of the element
     * @param props Map of attribute names and values
     */
    public static void setAttributeValues(ObjectName objectName, HashMap props) {
        Iterator<String> it = props.keySet().iterator();

        while (it.hasNext()) {
            String propName = it.next();
            Object value = props.get(propName);
            Attribute attribute = new Attribute(propName, value);
            JMXUtil.setAttribute(objectName, attribute);
        }
    }

    /**
     * The function is called to get the default attribute values for an element
     *
     * @param objectName The ObjectName of the element
     * @param propNames Array of attribute names
     * @return Map of default attribute values for the specified attributes
     */
    public static HashMap getDefaultAttributeValues(ObjectName objectName,
        String[] propNames) {
        HashMap props = new HashMap();

        try {
            for (String attributeName : propNames) {
                Object value = JMXUtil.getDefaultAttributeValue(objectName.getCanonicalName(),
                        new String[] { attributeName });
                props.put(attributeName,
                    ((value == null) ? " " : value.toString()));
            }

            return props;
        } catch (Exception ex) {
            System.out.println("Exception :" + ex.getMessage());

            return null;
        }
    }

    /**
     * This function returns the sip-listener element ObjectName
     * @param sipConfigBeanName sip-service element
     * @param listenerName The listener id
     * @return ObjectName representing the sip-listener
     */
    public static ObjectName getSipListener(ObjectName sipConfigBeanName,
        String listenerName) {
        ObjectName sipListener = (ObjectName) JMXUtil.invoke(sipConfigBeanName,
                "getSipListenerById", new Object[] { listenerName}, new String[] {"java.lang.String"});

        return sipListener;
    }

    /**
     *
     * @param objectValue
     * @return
     */
    public static boolean getBooleanValue(Object objectValue) {
        if (objectValue == null) {
            return false;
        }

        return new Boolean(objectValue.toString()).booleanValue();
    }

    /** The function updates the properties of an element. The skipList is used to skip over the properties
     *  that are defined in this list. These properties would be handled through the changeProperty method.
     *  Usually these are the properties that are always visible on the page and not in the properties
     *  table
     */
    public static void updateProperties(ObjectName element,
        HashMap<String, Object> newProps, List skipList) {
        HashMap oldProps = getProperties(element);

        //Remove any property that is no longer in the new list
        Iterator iter = oldProps.keySet().iterator();

        while (iter.hasNext()) {
            Object key = iter.next();

            if (skipList.contains(key)) {
                continue;
            }

            if (!newProps.containsKey(key)) {
                setProperty(element, (String) key, null);
            }
        }

        //update the value if the value is different or create a new property if it doesn't exist before
        for (String propName : newProps.keySet()) {
            String val = (String) newProps.get(propName);

            if (oldProps.containsKey(propName)) {
                //update
                String oldValue = (String) oldProps.get(propName);

                if ((!oldValue.equals(val)) && (!GuiUtil.isEmpty(val))) {
                    setProperty(element, propName, val);
                }
            } else {
                //new prop
                if (!GuiUtil.isEmpty(val)) {
                    setProperty(element, propName, val);
                }
            }
        }
    }

    /** The fucntion is called to change the value of a property or delete the same. This function is
     *  usually called for the properties that are always visible on the page
     */
    public static void changeProperty(ObjectName element, String propName,
        String propValue) {
        HashMap oldProps = getProperties(element);

        if (oldProps.containsKey(propName)) {
            if (GuiUtil.isEmpty(propValue)) {
                setProperty(element, propName, null);
            } else {
                setProperty(element, propName, propValue);
            }
        } else {
            if (!GuiUtil.isEmpty(propValue)) {
                setProperty(element, propName, propValue);
            }
        }
    }

    public static ObjectName getSipApplication(String appName) {
        return getSipApplication(APP_OBJECT_NAME, appName);
    }
    
    public static ObjectName getSipApplication(String objectName, String name) {
        try {
            ObjectName[] modules = (ObjectName[]) JMXUtil.invoke(objectName,
                    "getExtensionModule", null, null);

            for (ObjectName module : modules) {
                String moduleType = (String) JMXUtil.getAttribute(module,
                        "module-type");
                String moduleName = (String) JMXUtil.getAttribute(module, "name");

                if ((SIP_MODULE_TYPE.equals(moduleType)) &&
                        (moduleName.equals(name))) {
                    return module;
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return null;
    }
    
    public static String getMessage(HandlerContext handlerContext, String key, Object args[]) {
        if ((key == null) || (key.trim().length() == 0)) {
            return null;
        }
        
        if ((handlerContext == null) || (key.indexOf(".") == -1)) {
            MessageUtil msgUtil = MessageUtil.getInstance();
            return msgUtil.getMessage(SIP_RESOURCE_BUNDLE, key, args);
        } else {
            String resourceKey = key.substring(0, key.indexOf("."));
            key = key.substring(key.indexOf(".")+1);
            Object obj = handlerContext.getFacesContext().getExternalContext().getRequestMap().get(resourceKey);
            if ((obj == null) || (!(obj instanceof ResourceBundle))) {
                MessageUtil msgUtil = MessageUtil.getInstance();
                return msgUtil.getMessage(SIP_RESOURCE_BUNDLE, key, args);
            }
            
            ResourceBundle bundle = (ResourceBundle) obj;
            String message = bundle.getString(key);
            if ((args != null) && (args.length > 0)) {
                Object mfArgs[] = new Object[args.length];
                for (int i=0; i < args.length; i++) {
                    mfArgs[i] = bundle.getString(args[i].toString());
                }
                message = MessageUtil.getInstance().getFormattedMessage(message, mfArgs);
            }
            return message;
        }
    }
    
    public static String getMessage(String key, Object args[]) {
        if ((key == null) || (key.trim().length() == 0)) {
            return null;
        }
        
        MessageUtil msgUtil = MessageUtil.getInstance();
        return msgUtil.getMessage(SIP_RESOURCE_BUNDLE, key, args);
    }
    
    public static ObjectName getSipService(String configName) {
        String objectName = SIP_CONFIG_OBJECT_NAME + ",name=" + configName;
        try {
            return (ObjectName) JMXUtil.invoke(new ObjectName(objectName), "getSipService", null, null);
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
    
    public static  String[] getSelectedCiphersList(String selectedCiphers) {
        Vector selItems = new Vector();

        if (selectedCiphers != null) {
            String[] sel = selectedCiphers.split(","); //NOI18N

            for (int i = 0; i < sel.length; i++) {
                String cName = sel[i];

                if (cName.startsWith("+")) { //NOI18N
                    cName = cName.substring(1, cName.length());
                    selItems.add(cName);
                }
            }
        }

        return (String[]) selItems.toArray(new String[selItems.size()]);
    }

    public static  String processSelectedCiphers(String[] selectedCiphers,
        String ciphers) {
        if (selectedCiphers != null) {
            for (int i = 0; i < selectedCiphers.length; i++) {
                if (!ciphers.equals("")) {
                    ciphers += ",";
                }

                ciphers += ("+" + selectedCiphers[i]);
            }
        }

        return ciphers;
    }

    public static  Vector getCiphersVector(String[] allCiphers) {
        Vector ciphers = new Vector();

        for (int i = 0; i < allCiphers.length; i++) {
            ciphers.add(allCiphers[i]);
        }

        return ciphers;
    }

    public static  String[] getCommonCiphers(Vector ciphers) {
        Vector commonCiphers = filterCiphers(ciphers, COMMON_CIPHERS);
        String[] ciphersList = (String[]) commonCiphers.toArray(new String[commonCiphers.size()]);
        ;

        return ciphersList;
    }

    public static  String[] getEccCiphers(Vector ciphers) {
        Vector eccCiphers = breakUpCiphers(new Vector(), ciphers, "ECDH"); //NOI18N
        eccCiphers = breakUpCiphers(eccCiphers, ciphers, "ECDHE"); //NOI18N

        String[] ciphersList = (String[]) eccCiphers.toArray(new String[eccCiphers.size()]);

        return ciphersList;
    }

    public static  String[] getEphemeralCiphers(Vector ciphers) {
        Vector ephmCiphers = breakUpCiphers(new Vector(), ciphers, "DHE_RSA"); //NOI18N
        ephmCiphers = breakUpCiphers(ephmCiphers, ciphers, "DHE_DSS"); //NOI18N

        String[] ciphersList = (String[]) ephmCiphers.toArray(new String[ephmCiphers.size()]);

        return ciphersList;
    }

    public static  String[] getOtherCiphers(Vector ciphers) {
        Vector bitCiphers = filterCiphers(ciphers, BIT_CIPHERS);
        String[] ciphersList = (String[]) bitCiphers.toArray(new String[bitCiphers.size()]);

        return ciphersList;
    }

    public static  Vector filterCiphers(Vector ciphers, String[] filterList) {
        Vector listCiphers = new Vector();

        for (int i = 0; i < ciphers.size(); i++) {
            String cipherName = ciphers.get(i).toString();

            if (Arrays.asList(filterList).contains(cipherName)) {
                listCiphers.add(ciphers.get(i));
            }
        }

        return listCiphers;
    }

    public static  Vector breakUpCiphers(Vector cipherSubset,
        Vector allCiphers, String type) {
        for (int i = 0; i < allCiphers.size(); i++) {
            String cipherName = allCiphers.get(i).toString();

            if (cipherName.indexOf(type) != -1) {
                if (!Arrays.asList(BIT_CIPHERS).contains(cipherName)) {
                    cipherSubset.add(cipherName);
                }
            }
        }

        return cipherSubset;
    }
    
    /** This method is used to get the default values of attributes for an element.
     *  attributeName == null implies all attributes.
     */
    public static HashMap getDefaultAttributeValues(String element, String[] attributeNames) {
        String domainConfigObjectName = "com.sun.appserv:type=domain,category=config";
        HashMap defaultMap = new HashMap();
        try {
            AttributeList retVal = (AttributeList) JMXUtil.invoke(domainConfigObjectName, 
                    "getDefaultAttributeValues",
                    new Object[]{element, attributeNames},
                    new String[]{String.class.getName(), String[].class.getName()});
            if (retVal != null) {
                for(int i=0; i<retVal.size(); i++) {
                    Attribute attr = (Attribute) retVal.get(i);
                    defaultMap.put(attr.getName(), attr.getValue());
                }
            }
        } catch (Exception ex) {
            //do nothing
        }
        return defaultMap;
        
    }

    public static HashMap getDefaultAttributeValues(String elementName) {
        return getDefaultAttributeValues(elementName, null);
    }
    
    
    public static Object getChildByFunction(ObjectName component, String method) throws Exception {
        try {
            return getChildByFunction(component, method, null, null);
        } catch (Exception ex) {
            if (ex.getCause() instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
        
    }
    
    public static Object getChildByFunction(String objectName, String method, Object[] params, 
            String[] types) throws Exception {
        try {
            ObjectName component = new ObjectName((String)objectName);
            return getChildByFunction(component, method, params, types);
        } catch (Exception ex) {
            if (ex.getCause() instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
        
    }
    
    public static Object getChildByFunction(ObjectName objectName, String method, Object[] params, 
            String[] types) throws Exception {
        try {
            return JMXUtil.invoke(objectName, method, params, types);
        } catch (Exception ex) {
            if (ex.getCause() instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
        
    }

    public static ObjectName createChildByFunction(ObjectName parent, String method) throws Exception {
        ObjectName child = (ObjectName) JMXUtil.invoke(parent, method,
                new Object[]{SipUtil.EMPTY_LIST},
                new String[]{SipUtil.EMPTY_LIST.getClass().getName()});
        return child;
    }

    public static AttributeList convertMapToAttributeList(HashMap<String,Object> attrMap) {
        AttributeList list = new AttributeList();
        if((attrMap == null) || (attrMap.size() == 0)) {
            return list;
        }
        
        Set<String> keys = attrMap.keySet();
        for(String keyName : keys) {
            Object value = attrMap.get(keyName);
            if(value != null) {
                Attribute attr = new Attribute(keyName, value);
                list.add(attr);
            }
        }
        
        return list;
    }

    public static String[] getSignatureArray(Object[] params) {
        String signatures[] = new String[params.length];
        for (int i=0; i<params.length; i++) {
            signatures[i] = (params[i] == null) ? "java.lang.String" : params[i].getClass().getName();
        }
        return signatures;
    }
    
    /**
     *	The function is called to gather information about the deployed SIP Modules.
     * @return Hashmap of HashMaps containing information pertaining to each deployed module
     */
    public static HashMap getDeployedSIPModules() {
	HashMap modules = new HashMap();
	ObjectName[] sipModules = (ObjectName[]) JMXUtil.invoke(APP_OBJECT_NAME,
                "getExtensionModule", null, null);
	for (ObjectName sipApp : sipModules) {
            String moduleType = (String) JMXUtil.getAttribute(sipApp,
                    "module-type");

            if (SIP_MODULE_TYPE.equals(moduleType)) {
		// get App Name
		HashMap sipAppAttributes = getAttributeValues(sipApp,
                        new String[]{"name"});
                HashMap sipAppProps = SipUtil.getProperties(sipApp);
                Boolean isConvergedApp = Boolean.parseBoolean((String) sipAppProps.get("isConverged"));

                HashMap sipInfoMap = new HashMap();
                String enable = SipTargetUtil.getEnabledStatus(sipApp);
                sipInfoMap.put("enabled", enable);

                String name = (String) sipAppAttributes.get("name");
                sipInfoMap.put("appName", name);
		if (isConvergedApp) {
		    sipInfoMap.put("appType", "convergedSipModule");
		    sipInfoMap.put("appTypeLabel", getMessage("convergedSipModuleEdit.label", null));
		} else {
		    sipInfoMap.put("appType", "sipModule");
		    sipInfoMap.put("appTypeLabel", getMessage("sipModuleEdit.label", null));
		}
		
		modules.put(name, sipInfoMap);
	    }
	}
	return modules;
    }
    
    /**
     *	The function is used to resolve the properties for the port which are specified as $ 
     *	variables.
     * @param pn    port number as the variable name without the ${}
     * @param configName    Configuration on which to resolve the token
     * @param instanceName  Instance on which to resolve the token
     * @return	String port property value represented by the variable
     */
    public static String resolveToken(String pn, String configName, String instanceName) {
	//For EE, the instance will have its own override System Properties value instead of using the one from config.
	if (AMXUtil.isEE()) {
	    SystemPropertiesAccess sprops = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
	    if (sprops == null) {
		sprops = AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
	    }
	    if (sprops != null) {
		if (sprops.existsSystemProperty(pn)) {
		    return sprops.getSystemPropertyValue(pn);
		}
	    }
	}
	ConfigConfig config = AMXUtil.getConfig(configName);
	return config.getSystemPropertyValue(pn);
    }
    
    /**
     *	The function converts an attribute name into camel-case notation. JSFTemplating framework
     *	has problems displaying values that have a '-' in them
     *	Eg: is-default -> isDefault
     * @param name
     * @return
     */
    public static String toCamelCase(String name) {
	StringTokenizer tokens = new StringTokenizer(name, "-");
	StringBuffer camelCaseString = new StringBuffer(tokens.nextToken());
	while(tokens.hasMoreTokens()) {
	    String str = tokens.nextToken();
	    camelCaseString.append(String.valueOf(str.charAt(0)).toUpperCase());
	    camelCaseString.append(str.substring(1));
	}
	return camelCaseString.toString();
    }
}
