/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.management.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.support.TypeData;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;
import org.jvnet.glassfish.comms.management.config.SIPServiceConfig;
import org.jvnet.glassfish.comms.management.config.SIPListenerConfig;
import org.jvnet.glassfish.comms.management.config.SIPProtocolConfig;
import org.jvnet.glassfish.comms.management.config.SIPLinkConfig;
import org.jvnet.glassfish.comms.management.config.SIPTimersConfig;
import org.jvnet.glassfish.comms.management.config.SIPContainerConfig;
import org.jvnet.glassfish.comms.management.config.SIPContainerAvailabilityConfig;

import org.jvnet.glassfish.comms.management.config.IdentityAssertionTrustConfig;
import org.jvnet.glassfish.comms.management.config.TrustHandlerConfig;
import org.jvnet.glassfish.comms.management.config.TrustedEntityConfig;

import org.jvnet.glassfish.comms.management.config.ConvergedLoadBalancerConfig;
import org.jvnet.glassfish.comms.management.config.ConvergedLBConfig;
import org.jvnet.glassfish.comms.management.config.ConvergedLBPolicyConfig;
import org.jvnet.glassfish.comms.management.config.ProxyConfig;
import org.jvnet.glassfish.comms.management.config.ConvergedLBClusterRefConfig;

import org.jvnet.glassfish.comms.management.monitor.SIPServiceMonitor;
import org.jvnet.glassfish.comms.management.monitor.NetworkManagerMonitor;
import org.jvnet.glassfish.comms.management.monitor.DialogManagerMonitor;
import org.jvnet.glassfish.comms.management.monitor.TransactionManagerMonitor;
import org.jvnet.glassfish.comms.management.monitor.OverloadProtectionManagerMonitor;

//import com.sun.enterprise.admin.pluggable.AMXSupportExtensionFeature;
import com.sun.appserv.management.ext.support.ExtendedAMX;

/**
 * Pluggable AMX Support feature for SIP interfaces.
 * This is the implementation class for the extended AMX support features.
 *
 * The following data will be returned to the AMX support layer
 * 1. List of the MBean interface classes for config and monitor types
 * 2. Mapping of the interfaces and the implementation packages
 * 3. The new config types (DATA) 
 * 4. The new monitor types (MONITOR_DATA)
 * 5. The new config types children 
 * 6. The new monitor types children 
 * 7. The old config types
 * 8. The old monitor types
 *
 * @author: Yamini K B
 */
public class SIPAMXSupport implements ExtendedAMX {
//public class SIPAMXSupport implements AMXSupportExtensionFeature {

    private static final String CONFIG_INTERFACE_PACKAGE = "org.jvnet.glassfish.comms.management.config.";
    private static final String CONFIG_IMPL_PACKAGE = "org.jvnet.glassfish.comms.admin.management.extensions.config.";
    private static final String MONITOR_INTERFACE_PACKAGE = "org.jvnet.glassfish.comms.management.monitor.";
    private static final String MONITOR_IMPL_PACKAGE = "org.jvnet.glassfish.comms.admin.management.extensions.monitor.";

    private static final Class[] EXT_MBEAN_INTERFACES = {
        // SIP container
        SIPServiceConfig.class,
        SIPListenerConfig.class,
        SIPProtocolConfig.class,
        SIPLinkConfig.class,
        SIPTimersConfig.class,
        SIPContainerConfig.class,
        SIPContainerAvailabilityConfig.class,
        // CLB
        ConvergedLoadBalancerConfig.class,
        ConvergedLBConfig.class,
        ConvergedLBPolicyConfig.class,
        ConvergedLBClusterRefConfig.class,
        ProxyConfig.class,
        // SIP security
        IdentityAssertionTrustConfig.class,
        TrustHandlerConfig.class,
        TrustedEntityConfig.class,
        // SIP monitoring
        SIPServiceMonitor.class,
        NetworkManagerMonitor.class,
        DialogManagerMonitor.class,
        TransactionManagerMonitor.class,
        OverloadProtectionManagerMonitor.class,
    };

    /*
     * Child types
     */
    private static final TypeData[] DATA  = new TypeData[]
    {
        new NewDomainConfigChild( SIPXTypes.CONVERGED_LB_CONFIG ),

        new NewConfigConfigChild( SIPXTypes.SIP_SERVICE_CONFIG),
        new NewConfigConfigChild( SIPXTypes.SIP_CONTAINER_CONFIG),

        new NewSecurityServiceConfigChild( SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG ),

        new SIPServiceChild( SIPXTypes.SIP_LISTENER_CONFIG ),
        new SIPServiceChild( SIPXTypes.SIP_PROTOCOL_CONFIG ),

        new ConvergedLBConfigChild( SIPXTypes.CONVERGED_LB_POLICY_CONFIG ),
        new ConvergedLBConfigChild( SIPXTypes.CONVERGED_LB_CLUSTER_REF_CONFIG ),

        new IdentityAssertionTrustConfigChild( SIPXTypes.TRUST_HANDLER_CONFIG ),
        new IdentityAssertionTrustConfigChild( SIPXTypes.TRUSTED_ENTITY_CONFIG ),

        new NewMiscChild( SIPXTypes.SIP_LINK_CONFIG, SIPXTypes.SIP_PROTOCOL_CONFIG),
        new NewMiscChild( SIPXTypes.SIP_TIMERS_CONFIG, SIPXTypes.SIP_PROTOCOL_CONFIG),
        new NewMiscChild( SIPXTypes.CONVERGED_LOAD_BALANCER_CONFIG, XTypes.AVAILABILITY_SERVICE_CONFIG ),
        new NewMiscChild( SIPXTypes.PROXY_CONFIG, SIPXTypes.CONVERGED_LOAD_BALANCER_CONFIG),
        new NewMiscChild( SIPXTypes.TRUST_HANDLER_CONFIG, SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG),
        new NewMiscChild( SIPXTypes.TRUSTED_ENTITY_CONFIG, SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG),

        new NewMiscChild( SIPXTypes.SIP_CONTAINER_AVAILABILITY_CONFIG, XTypes.AVAILABILITY_SERVICE_CONFIG ),

        // Monitor types
        new NewServerRootMonitorChild( SIPXTypes.SIP_SERVICE_MONITOR),
        new SIPServiceMonitorChild( SIPXTypes.NETWORK_MANAGER_MONITOR ),
        new SIPServiceMonitorChild( SIPXTypes.DIALOG_MANAGER_MONITOR ),
        new SIPServiceMonitorChild( SIPXTypes.TRANSACTION_MANAGER_MONITOR ),
        new SIPServiceMonitorChild( SIPXTypes.OVERLOAD_PROTECTION_MANAGER_MONITOR ),
    };

    private static final String[] IGNORE_TYPES = {
                                  "sip-configs",
                                  "converged-lb-configs",
                                  };

    public SIPAMXSupport() {
    }
    
    /*
     * Implementation to return new MBean interfaces
     */
    public Class[] getExternalMbeanInterfaces() {
        return EXT_MBEAN_INTERFACES;
    }

    /*
     * Get all the new types
     */
    public Object[] getNewTypeData() {
        return (Object[])DATA;
    }

    /*
     * Get the old config types 
     */
    public Map<String,String> getOldConfigTypes() {
        Map<String,String> m = new HashMap<String,String>();
        m.put(SIPXTypes.SIP_SERVICE_CONFIG, "sip-service");
        m.put(SIPXTypes.SIP_LISTENER_CONFIG, "sip-listener");
        m.put(SIPXTypes.SIP_PROTOCOL_CONFIG, "sip-protocol");
        m.put(SIPXTypes.SIP_LINK_CONFIG, "sip-link");
        m.put(SIPXTypes.SIP_TIMERS_CONFIG, "sip-timers");
        m.put(SIPXTypes.SIP_CONTAINER_CONFIG, "sip-container");
        m.put(SIPXTypes.SIP_CONTAINER_AVAILABILITY_CONFIG, "sip-container-availability");
        // Security config types
        m.put(SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG, "identity-assertion-trust");
        m.put(SIPXTypes.TRUST_HANDLER_CONFIG, "trust-handler");
        m.put(SIPXTypes.TRUSTED_ENTITY_CONFIG, "trusted-entity");
        // CLB config types
        m.put(SIPXTypes.CONVERGED_LOAD_BALANCER_CONFIG, "converged-load-balancer");
        m.put(SIPXTypes.PROXY_CONFIG, "proxy");
        m.put(SIPXTypes.CONVERGED_LB_CONFIG, "converged-lb-config");
        m.put(SIPXTypes.CONVERGED_LB_POLICY_CONFIG, "converged-lb-policy");
        m.put(SIPXTypes.CONVERGED_LB_CLUSTER_REF_CONFIG, "converged-lb-cluster-ref");
        return m;
    }

    /*
     * Get a mapping of interface and implementation class
     */
    public Map<String,String> getInterfaceImpls() {
        Map<String,String> m = new HashMap<String,String>();
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPServiceConfig", CONFIG_IMPL_PACKAGE+"SIPServiceConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPListenerConfig", CONFIG_IMPL_PACKAGE+"SIPListenerConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPProtocolConfig", CONFIG_IMPL_PACKAGE+"SIPProtocolConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPLinkConfig", CONFIG_IMPL_PACKAGE+"SIPLinkConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPTimersConfig", CONFIG_IMPL_PACKAGE+"SIPTimersConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPContainerConfig", CONFIG_IMPL_PACKAGE+"SIPContainerConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"SIPContainerAvailabilityConfig", CONFIG_IMPL_PACKAGE+"SIPContainerAvailabilityConfigImpl");
        // CLB config implementations
        m.put(CONFIG_INTERFACE_PACKAGE+"ConvergedLoadBalancerConfig", CONFIG_IMPL_PACKAGE+"ConvergedLoadBalancerConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"ProxyConfig", CONFIG_IMPL_PACKAGE+"ProxyConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"ConvergedLBConfig", CONFIG_IMPL_PACKAGE+"ConvergedLBConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"ConvergedLBPolicyConfig", CONFIG_IMPL_PACKAGE+"ConvergedLBPolicyConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"ConvergedLBClusterRefConfig", CONFIG_IMPL_PACKAGE+"ConvergedLBClusterRefConfigImpl");
        // Security config impls
        m.put(CONFIG_INTERFACE_PACKAGE+"IdentityAssertionTrustConfig", CONFIG_IMPL_PACKAGE+"IdentityAssertionTrustConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"TrustHandlerConfig", CONFIG_IMPL_PACKAGE+"TrustHandlerConfigImpl");
        m.put(CONFIG_INTERFACE_PACKAGE+"TrustedEntityConfig", CONFIG_IMPL_PACKAGE+"TrustedEntityConfigImpl");

        m.put(MONITOR_INTERFACE_PACKAGE+"SIPServiceMonitor", MONITOR_IMPL_PACKAGE+"SIPServiceMonitorImpl");
        m.put(MONITOR_INTERFACE_PACKAGE+"NetworkManagerMonitor", MONITOR_IMPL_PACKAGE+"NetworkManagerMonitorImpl");
        m.put(MONITOR_INTERFACE_PACKAGE+"DialogManagerMonitor", MONITOR_IMPL_PACKAGE+"DialogManagerMonitorImpl");
        m.put(MONITOR_INTERFACE_PACKAGE+"TransactionManagerMonitor", MONITOR_IMPL_PACKAGE+"TransactionManagerMonitorImpl");
        m.put(MONITOR_INTERFACE_PACKAGE+"OverloadProtectionManagerMonitor", MONITOR_IMPL_PACKAGE+"OverloadProtectionManagerMonitorImpl");
        return m;
    }

    /*
     * Get all the old monitor types 
     */
    public Map<String,String> getOldMonitorTypes() {
        Map<String,String> m = new HashMap<String,String>();
        m.put(SIPXTypes.SIP_SERVICE_MONITOR, "sip-service");
        m.put(SIPXTypes.NETWORK_MANAGER_MONITOR, "network-manager");
        m.put(SIPXTypes.DIALOG_MANAGER_MONITOR, "session-manager");
        m.put(SIPXTypes.TRANSACTION_MANAGER_MONITOR, "transaction-manager");
        m.put(SIPXTypes.OVERLOAD_PROTECTION_MANAGER_MONITOR, "overload-protection-manager");
        return m;
    }

    /*
     * Get all the ignorable mbean types
     * This will add to the list maintained in OldConfigTypes
     */
    public String[] getIgnoreTypes() {
        return IGNORE_TYPES;
    }

    private static final class NewConfigConfigChild extends TypeData
    {
        public NewConfigConfigChild( final String    j2eeType  )
        {
            super( j2eeType, XTypes.CONFIG_CONFIG );
        }
    }

    private static final class NewMiscChild extends TypeData
    {
        public NewMiscChild( final String    j2eeType,
                             final String    parentJ2EEType )
        {
            super( j2eeType, parentJ2EEType );
        }
    }

    private static final class NewServerRootMonitorChild extends TypeData
    {
        public NewServerRootMonitorChild( final String     j2eeType  )
        {
            super( j2eeType, XTypes.SERVER_ROOT_MONITOR );
        }
    }

    private static final class SIPServiceChild extends TypeData
    {
        public SIPServiceChild( final String    j2eeType  )
        {
            super( j2eeType, SIPXTypes.SIP_SERVICE_CONFIG );
        }
    }

    private static final class SIPServiceMonitorChild extends TypeData
    {
        public SIPServiceMonitorChild( final String    j2eeType  )
        {
            super( j2eeType, SIPXTypes.SIP_SERVICE_MONITOR );
        }
    }

    private static final class NewSecurityServiceConfigChild extends TypeData
    {
        public NewSecurityServiceConfigChild( final String    j2eeType  )
        {
            super( j2eeType, XTypes.SECURITY_SERVICE_CONFIG );
        }
    }

    private static final class NewDomainConfigChild extends TypeData
    {
        public NewDomainConfigChild( final String    j2eeType  )
        {
            super( j2eeType, XTypes.DOMAIN_CONFIG );
        }
    }

    private static final class ConvergedLBConfigChild extends TypeData
    {
        public ConvergedLBConfigChild( final String    j2eeType  )
        {
            super( j2eeType, SIPXTypes.CONVERGED_LB_CONFIG );
        }
    }

    private static final class IdentityAssertionTrustConfigChild extends TypeData
    {
        public IdentityAssertionTrustConfigChild( final String    j2eeType  )
        {
            super( j2eeType, SIPXTypes.IDENTITY_ASSERTION_TRUST_CONFIG );
        }
    }
}
