/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.admin.management.extensions.config;

import java.util.Map;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.config.SSLConfigKeys;
import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.config.ConfigFactoryCallback;

import com.sun.enterprise.management.support.AMXAttributeNameMapper;

import org.jvnet.glassfish.comms.management.config.TrustedEntityConfig;

/**
    Configuration for the &lt;trusted-entity&gt; element.
 */
public final class TrustedEntityConfigImpl extends AMXConfigImplBase
    implements ConfigFactoryCallback
{
    public TrustedEntityConfigImpl( final Delegate    delegate )
    {
        super( delegate );
    }

    private TrustedEntityConfig self()
    {
        return (TrustedEntityConfig)getSelf();
    }

    public void createHostName( final String hostname )
    {
        delegateSetAttributeNoThrow( "HostName", hostname );
    }

    public void removeHostName( final String hostname )
    {
        delegateSetAttributeNoThrow( "HostName", hostname );
    }

    public void createIPAddress( final String ipAddress )
    {
        delegateSetAttributeNoThrow( "IpAddress", ipAddress );
    }

    public void removeIPAddress( final String ipAddress )
    {
        delegateSetAttributeNoThrow( "IpAddress", ipAddress );
    }

    public void createPrincipal( final String principal )
    {
        delegateSetAttributeNoThrow( "Principal", principal );
    }

    public void removePrincipal( final String principal )
    {
        delegateSetAttributeNoThrow( "Principal", principal );
    }
}
