/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;
import java.util.Date;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

import com.sun.appserv.management.config.ConfigRemover;

/**
 *  Supports creation and removal of converged LB cluster references
 */
public interface ConvergedLBClusterRefConfigCR extends
        ConfigRemover
{

    public static final String  REF_KEY = "Ref";
    public static final String  SELF_LOADBALANCE_KEY = "SelfLoadbalance";

    /**
     * Creates a new converged-lb-cluster-ref for a converged-lb-config.
     *  @param clusterName A reference to the name of a cluster.
     *  @param reserved   reserved for future use
     *  @return A proxy to the ClusterRefConfig MBean.
     */
    public ConvergedLBClusterRefConfig createConvergedLBClusterRefConfig(
        String clusterName, Map<String,String> reserved);

    /**
     * Removes a converged-lb-cluster-ref for an converged-lb-config.
     *  @param clusterName A reference to the name of a cluster.
     */
    public void removeConvergedLBClusterRefConfig(String clusterName );
}
