/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;
import java.util.Date;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ConfigElement;

/**
   Configuration for the converged-lb-policy element.
   @see org.jvnet.glassfish.comms.management.config.ConvergedLBConfig
 */
public interface ConvergedLBPolicyConfig extends
        ConfigElement, PropertiesAccess
{

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String  J2EE_TYPE = SIPXTypes.CONVERGED_LB_POLICY_CONFIG;

    /**
        Gets the HTTP policy for the converged LB
     */
    public String getHttp();

    /**
        Specifies the load balancing policy used for the http
        requests. The default implied value is round-robin.
     */
    public void setHttp( final String http);

    /**
        Gets the SIP policy for the converged LB
     */
    public String getSip();

    /**
        Specifies the parameters on which consistent hashing policy
        is applied to obtain the hashkey. This can be specified as
        single value or comma seperated values of parameter names to
        hash on. In case more than one parameter is specified, then
        the concatenated values of the parameters would be used for
        applying the consistent hashing. The default value implied
        will be "from-tag,to-tag,call-id".
     */
    public void setSip( final String sip);

    /**
        Gets the data centric rules file name
     */
    public String getDcrFile();

    /**
        Sets the data centric rules file name
     */
    public void setDcrFile( final String dcrFile);
}
