/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;
import java.util.Date;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.config.NamedConfigElement;

/**
   Configuration for the converged-load-balancer element.
 */
public interface ConvergedLoadBalancerConfig extends
        NamedConfigElement, Container
{

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String  J2EE_TYPE = SIPXTypes.CONVERGED_LOAD_BALANCER_CONFIG;

    public ProxyConfig createProxyConfig( Map<String,String> params);
    public void removeProxyConfig();
    /**
        Returns the converged load balancer name
     */
    public String getName();

    /**
        Sets the converged load balancer name
     */
    public void setName( final String name);

    /**
        Returns the converged load balancer config file name
     */
    public String getConfigFile();

    /**
        Converged load balancer's configuration file. This can be an
        absolute or relative path. Relative path is resolved with the
        config directory of the server.
     */
    public void setConfigFile( final String fileName);

    /**
       Returns if auto commit is turned on or not
     */
    public String getAutoCommit();

    /**
        When true, config file changes will be propagated to clb
        instances immediately.
     */
    public void setAutoCommit( final String value);

    /**
        Gets the referencing converged-lb-config name
     */
    public String getConvergedLBConfigName();

    /**
        Sets the referencing converged-lb-config name
     */
    public void setConvergedLBConfigName();
}
